# Conditional Fields

Conditional Fields allows you to manage sets of dependencies between fields.
When a field is “dependent”, it will only be available for editing and displayed
if the state of the “dependee” field matches the right condition.
When editing a node (or any other entity type that supports fields, like users
and categories), the dependent fields are dynamically modified with the States
API. A simple use case would be defining a custom “Article teaser" field that is
shown only if a "Has teaser" checkbox is checked, but much more complex options
are available.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/conditional_fields).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/conditional_fields).


## Table of contents

- Requirements
- Installation
- Configuration
- Maintainers


## Requirements

This module requires no modules outside of Drupal core.


## Installation

Install as you would normally install a contributed Drupal module.For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

After enable the module, you can create conditional fields on
/admin/structure/conditional_fields.


## Maintainers

- Colan Schwartz - [colan](https://www.drupal.org/u/colan)
- Christopher Gervais - [ergonlogic](https://www.drupal.org/u/ergonlogic)
- Merlin Axel Rutz - [geek-merlin](https://www.drupal.org/u/geek-merlin)
- Olga Rabodzei - [olgarabodzei](https://www.drupal.org/u/olgarabodzei)
- Thalles Ferreira - [thalles](https://www.drupal.org/u/thalles)
- M Parker - [mparker17](https://www.drupal.org/u/mparker17)
- Gregorio Magini - [peterpoe](https://www.drupal.org/u/peterpoe)
- Ivan Tsekhmistro - [itsekhmistro](https://www.drupal.org/u/itsekhmistro)
- Lucas Hedding - [heddn](https://www.drupal.org/u/heddn)
