<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* themes/custom/quitpath/templates/paragraph/paragraph--featured-content.html.twig */
class __TwigTemplate_5ead11edf50b82d72ff59211fdac4f4d extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'paragraph' => [$this, 'block_paragraph'],
            'content' => [$this, 'block_content'],
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 42
        $context["classes"] = ["paragraph", ("paragraph--type--" . \Drupal\Component\Utility\Html::getClass(CoreExtension::getAttribute($this->env, $this->source,         // line 44
($context["paragraph"] ?? null), "bundle", [], "any", false, false, true, 44))), ((        // line 45
($context["view_mode"] ?? null)) ? (("paragraph--view-mode--" . \Drupal\Component\Utility\Html::getClass(($context["view_mode"] ?? null)))) : ("")), (( !CoreExtension::getAttribute($this->env, $this->source,         // line 46
($context["paragraph"] ?? null), "isPublished", [], "method", false, false, true, 46)) ? ("paragraph--unpublished") : (""))];
        // line 49
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image_alt_text", [], "any", false, false, true, 49), "value", [], "any", false, false, true, 49))) {
            // line 50
            yield "  ";
            $context["alt_text"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image_alt_text", [], "any", false, false, true, 50), "value", [], "any", false, false, true, 50);
        } else {
            // line 52
            yield "  ";
            $context["alt_text"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 52), "entity", [], "any", false, false, true, 52), "field_media_image", [], "any", false, false, true, 52), "alt", [], "any", false, false, true, 52);
        }
        // line 54
        yield "
";
        // line 55
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_tags", [], "any", false, false, true, 55), "value", [], "any", false, false, true, 55))) {
            // line 56
            yield "    ";
            $context["title_heading"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_tags", [], "any", false, false, true, 56), "value", [], "any", false, false, true, 56);
        } else {
            // line 58
            yield "    ";
            $context["title_heading"] = "h5";
        }
        // line 60
        yield "
";
        // line 61
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_size_weight", [], "any", false, false, true, 61), "value", [], "any", false, false, true, 61))) {
            // line 62
            yield "    ";
            $context["heading_class"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_size_weight", [], "any", false, false, true, 62), "value", [], "any", false, false, true, 62);
        } else {
            // line 64
            yield "    ";
            $context["heading_class"] = "font-medium";
        }
        // line 66
        yield "

";
        // line 68
        yield from $this->unwrap()->yieldBlock('paragraph', $context, $blocks);
        // line 93
        yield " 
 
";
        $this->env->getExtension('\Drupal\Core\Template\TwigExtension')
            ->checkDeprecations($context, ["paragraph", "view_mode"]);        yield from [];
    }

    // line 68
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_paragraph(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 69
        yield "    ";
        yield from $this->unwrap()->yieldBlock('content', $context, $blocks);
        yield from [];
    }

    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 70
        yield "        ";
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_box_alignment", [], "any", false, false, true, 70), "value", [], "any", false, false, true, 70) == "right")) {
            // line 71
            yield "            <div class=\"border-2 md:border-[5px] border-black shadow-[7px_12px_0px_rgba(0,0,0,0.08)] rounded-[20px] lg:rotate-[5.61deg] lg:ml-[17.36px] hover:scale-[1.05] duration-300 p-3.75 md:p-6.25 text-center space-y-2.5 md:space-y-3.75\">
        ";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source,         // line 72
($context["paragraph"] ?? null), "field_box_alignment", [], "any", false, false, true, 72), "value", [], "any", false, false, true, 72) == "center")) {
            // line 73
            yield "            <div class=\"border-2 md:border-[5px] border-black shadow-[7px_12px_0px_rgba(0,0,0,0.08)] rounded-[20px] lg:rotate-[2.59deg] lg:ml-[8.32px] hover:scale-[1.05] duration-300 p-3.75 md:p-6.25 text-center space-y-2.5 md:space-y-3.75\">
        ";
        } else {
            // line 75
            yield "            <div class=\"border-2 md:border-[5px] border-black shadow-[7px_12px_0px_rgba(0,0,0,0.08)] rounded-[20px] lg:-rotate-[3.97deg] lg:mr-[13.76px] hover:scale-[1.05] duration-300 p-3.75 md:p-6.25 text-center space-y-2.5 md:space-y-3.75\">

        ";
        }
        // line 78
        yield "        
        
            <div>
                <img src=\"";
        // line 81
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, $this->extensions['Drupal\Core\Template\TwigExtension']->getFileUrl(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 81), "entity", [], "any", false, false, true, 81), "field_media_image", [], "any", false, false, true, 81), "entity", [], "any", false, false, true, 81), "uri", [], "any", false, false, true, 81), "value", [], "any", false, false, true, 81)), "html", null, true);
        yield "\" class=\"w-full rounded-[14px]\" alt=\"";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["alt_text"] ?? null), "html", null, true);
        yield "\">
            </div>
            <div class=\"space-y-2.5 md:space-y-3.75\">
                <";
        // line 84
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["title_heading"] ?? null), "html", null, true);
        yield " class=\"";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["heading_class"] ?? null), "html", null, true);
        yield "\">";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title", [], "any", false, false, true, 84), "value", [], "any", false, false, true, 84));
        yield "</";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["title_heading"] ?? null), "html", null, true);
        yield ">
                ";
        // line 85
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_description", [], "any", false, false, true, 85), "value", [], "any", false, false, true, 85));
        yield "
            </div>
            <div>
                <a href=\"";
        // line 88
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_link", [], "any", false, false, true, 88), "get", [0], "method", false, false, true, 88), "getUrl", [], "method", false, false, true, 88), "toString", [], "method", false, false, true, 88), "html", null, true);
        yield "\" class=\"max-md:font-semibold\">";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_link", [], "any", false, false, true, 88), "title", [], "any", false, false, true, 88), "html", null, true);
        yield " ➜</a>
            </div>
        </div>
    ";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "themes/custom/quitpath/templates/paragraph/paragraph--featured-content.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  166 => 88,  160 => 85,  150 => 84,  142 => 81,  137 => 78,  132 => 75,  128 => 73,  126 => 72,  123 => 71,  120 => 70,  108 => 69,  101 => 68,  93 => 93,  91 => 68,  87 => 66,  83 => 64,  79 => 62,  77 => 61,  74 => 60,  70 => 58,  66 => 56,  64 => 55,  61 => 54,  57 => 52,  53 => 50,  51 => 49,  49 => 46,  48 => 45,  47 => 44,  46 => 42,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{#
/**
 * @file
 * Default theme implementation to display a paragraph.
 *
 * Available variables:
 * - paragraph: Full paragraph entity.
 *   Only method names starting with \"get\", \"has\", or \"is\" and a few common
 *   methods such as \"id\", \"label\", and \"bundle\" are available. For example:
 *   - paragraph.getCreatedTime() will return the paragraph creation timestamp.
 *   - paragraph.id(): The paragraph ID.
 *   - paragraph.bundle(): The type of the paragraph, for example, \"image\" or \"text\".
 *   - paragraph.getOwnerId(): The user ID of the paragraph author.
 *   See Drupal\\paragraphs\\Entity\\Paragraph for a full list of public properties
 *   and methods for the paragraph object.
 * - content: All paragraph items. Use {{ content }} to print them all,
 *   or print a subset such as {{ content.field_example }}. Use
 *   {{ content|without('field_example') }} to temporarily suppress the printing
 *   of a given child element.
 * - attributes: HTML attributes for the containing element.
 *   The attributes.class element may contain one or more of the following
 *   classes:
 *   - paragraphs: The current template type (also known as a \"theming hook\").
 *   - paragraphs--type-[type]: The current paragraphs type. For example, if the paragraph is an
 *     \"Image\" it would result in \"paragraphs--type--image\". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - paragraphs--view-mode--[view_mode]: The View Mode of the paragraph; for example, a
 *     preview would result in: \"paragraphs--view-mode--preview\", and
 *     default: \"paragraphs--view-mode--default\".
 * - view_mode: View mode; for example, \"preview\" or \"full\".
 * - logged_in: Flag for authenticated user status. Will be true when the
 *   current user is a logged-in member.
 * - is_admin: Flag for admin user status. Will be true when the current user
 *   is an administrator.
 *
 * @see template_preprocess_paragraph()
 *
 * @ingroup themeable
 */
#}
{%
  set classes = [
    'paragraph',
    'paragraph--type--' ~ paragraph.bundle|clean_class,
    view_mode ? 'paragraph--view-mode--' ~ view_mode|clean_class,
    not paragraph.isPublished() ? 'paragraph--unpublished'
  ]
%}
{% if paragraph.field_image_alt_text.value is not empty %}
  {% set alt_text =  paragraph.field_image_alt_text.value  %}
{% else %}
  {% set alt_text =  paragraph.field_image.entity.field_media_image.alt  %}
{% endif %}

{% if paragraph.field_title_tags.value is not empty %}
    {% set title_heading =  paragraph.field_title_tags.value  %}
{% else %}
    {% set title_heading =  'h5'  %}
{% endif %}

{% if paragraph.field_title_size_weight.value is not empty %}
    {% set heading_class =  paragraph.field_title_size_weight.value  %}
{% else %}
    {% set heading_class =  'font-medium'  %}
{% endif %}


{% block paragraph %}
    {% block content %}
        {% if paragraph.field_box_alignment.value == \"right\" %}
            <div class=\"border-2 md:border-[5px] border-black shadow-[7px_12px_0px_rgba(0,0,0,0.08)] rounded-[20px] lg:rotate-[5.61deg] lg:ml-[17.36px] hover:scale-[1.05] duration-300 p-3.75 md:p-6.25 text-center space-y-2.5 md:space-y-3.75\">
        {% elseif paragraph.field_box_alignment.value == \"center\" %}
            <div class=\"border-2 md:border-[5px] border-black shadow-[7px_12px_0px_rgba(0,0,0,0.08)] rounded-[20px] lg:rotate-[2.59deg] lg:ml-[8.32px] hover:scale-[1.05] duration-300 p-3.75 md:p-6.25 text-center space-y-2.5 md:space-y-3.75\">
        {% else %}
            <div class=\"border-2 md:border-[5px] border-black shadow-[7px_12px_0px_rgba(0,0,0,0.08)] rounded-[20px] lg:-rotate-[3.97deg] lg:mr-[13.76px] hover:scale-[1.05] duration-300 p-3.75 md:p-6.25 text-center space-y-2.5 md:space-y-3.75\">

        {% endif %}
        
        
            <div>
                <img src=\"{{ file_url(paragraph.field_image.entity.field_media_image.entity.uri.value) }}\" class=\"w-full rounded-[14px]\" alt=\"{{ alt_text }}\">
            </div>
            <div class=\"space-y-2.5 md:space-y-3.75\">
                <{{ title_heading }} class=\"{{ heading_class }}\">{{ paragraph.field_title.value|raw }}</{{ title_heading }}>
                {{ paragraph.field_description.value|raw }}
            </div>
            <div>
                <a href=\"{{ paragraph.field_link.get(0).getUrl().toString() }}\" class=\"max-md:font-semibold\">{{ paragraph.field_link.title }} ➜</a>
            </div>
        </div>
    {% endblock %}
{% endblock paragraph %}
 
 
", "themes/custom/quitpath/templates/paragraph/paragraph--featured-content.html.twig", "/home/quitpathshareaco/public_html/web/themes/custom/quitpath/templates/paragraph/paragraph--featured-content.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["set" => 42, "if" => 49, "block" => 68];
        static $filters = ["clean_class" => 44, "escape" => 81, "raw" => 84];
        static $functions = ["file_url" => 81];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'if', 'block'],
                ['clean_class', 'escape', 'raw'],
                ['file_url'],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
