<?php

/**
 * @file
 * Acromedia Lagoon standards settings file.
 *
 * DO NOT EDIT THIS FILE. It will be overridden with new upstream changes.
 *
 * Place any custom site settings in `all.settings.php` or one of the
 * environment specific `*.settings.php` files.
 *
 * Settings and services files are loaded in this order:
 * - all.settings.php
 * - all.services.yml
 *   Applied to all environments.
 * - production.settings.php
 * - production.services.yml
 *   Only production environments.
 * - development.settings.php
 * - development.services.yml
 *   For all non-production environments.
 * - LAGOON_ENVIRONMENT.settings.php
 * - LAGOON_ENVIRONMENT.services.yml
 *   For specific non-production environments. Use 'pr' for all pull requests.
 * - settings.local.php
 * - services.local.yml
 *   Only for local environment.
 */

/**
 * Load services definition file.
 */
// Load the Drupal defaults first.
$settings['container_yamls'][] = __DIR__ . '/default.services.yml';
$settings['container_yamls'][] = __DIR__ . '/services.yml';

// Lagoon version.
if (!defined('LAGOON_VERSION')) {
  define('LAGOON_VERSION', '1');
}

// Lagoon database connection.
if (getenv('LAGOON')) {
  $databases['default']['default'] = [
    'driver'   => 'mysql',
    'database' => getenv('MARIADB_DATABASE') ?: 'drupal',
    'username' => getenv('MARIADB_USERNAME') ?: 'drupal',
    'password' => getenv('MARIADB_PASSWORD') ?: 'drupal',
    'host'     => getenv('MARIADB_HOST') ?: 'mariadb',
    'port'     => 3306,
    'prefix'   => '',
    'collation' => 'utf8mb4_unicode_ci'
  ];

  // Lagoon reverse proxy settings.
  $settings['reverse_proxy'] = TRUE;

  // Trusted Host Patterns.
  // Trusted host patterns are not necessary on lagoon as traffic will only
  // be routed to your site via the routes (hosts) defined in .lagoon.yml.
  $settings['trusted_host_patterns'][] = '.*';

  // Hash salt.
  // Use HASH_SALT if found in the current environment otherwise fallback on
  // MARIADB_HOST which is a randomly generated service name.
  $settings['hash_salt'] = hash('sha256', getenv('HASH_SALT') ?: getenv('MARIADB_HOST'));
}

// Temp directory.
if (getenv('TMP')) {
  $config['system.file']['path']['temporary'] = getenv('TMP');
}

// The default list of directories that will be ignored by Drupal's file API.
if (empty($settings['file_scan_ignore_directories'])) {
  $settings['file_scan_ignore_directories'] = [
    'node_modules',
    'bower_components',
  ];
}

// Default private files directory.
$settings['file_private_path'] = DRUPAL_ROOT . '/../private';
// Default config sync directory.
$settings["config_sync_directory"] = DRUPAL_ROOT . '/../config/sync';

// Set up the gyocf api settings.
$config['gyocf_visualization.settings']['api_key'] = getenv('GYOCF_API_KEY');
$config['gyocf_visualization.settings']['request_url'] = getenv('GYOCF_REQUEST_URL');

// Settings for all environments.
if (file_exists(__DIR__ . '/all.settings.php')) {
  include __DIR__ . '/all.settings.php';
}
// Services for all environments.
if (file_exists(__DIR__ . '/all.services.yml')) {
  $settings['container_yamls'][] = __DIR__ . '/all.services.yml';
}

if (getenv('LAGOON_ENVIRONMENT_TYPE')) {
  $lagoon_env_type = getenv('LAGOON_ENVIRONMENT_TYPE');
  // Environment specific settings files.
  if (file_exists(__DIR__ . '/' . $lagoon_env_type . '.settings.php')) {
    include __DIR__ . '/' . $lagoon_env_type . '.settings.php';
  }
  // Environment specific services files.
  if (file_exists(__DIR__ . '/' . $lagoon_env_type . '.services.yml')) {
    $settings['container_yamls'][] = __DIR__ . '/' . $lagoon_env_type . '.services.yml';
  }
  // Default settings for all development environments.
  // Be cautious as some of these may be public.
  if ($lagoon_env_type === 'development') {
    // @see https://www.drupal.org/node/2492225
    assert_options(ASSERT_ACTIVE, TRUE);
    \Drupal\Component\Assertion\Handle::register();
  }
  unset($lagoon_env_type);
}

if (getenv('LAGOON_ENVIRONMENT')) {
  $lagoon_env = getenv('LAGOON_ENVIRONMENT');
  $lagoon_env = strpos($lagoon_env, 'pr-') === 0 && getenv('LAGOON_PR_HEAD_BRANCH') ? 'pr' : $lagoon_env;
  // Environment specific settings files.
  if (file_exists(__DIR__ . '/' . $lagoon_env . '.settings.php')) {
    include __DIR__ . '/' . $lagoon_env . '.settings.php';
  }
  // Environment specific services files.
  if (file_exists(__DIR__ . '/' . $lagoon_env . '.services.yml')) {
    $settings['container_yamls'][] = __DIR__ . '/' . $lagoon_env . '.services.yml';
  }
  unset($lagoon_env);
}

// Last: this servers specific settings files.
if (file_exists(__DIR__ . '/settings.local.php')) {
  // Default local dev settings, these still can be overridden in settings.local.php.
  $settings['skip_permissions_hardening']            = TRUE;
  $config['system.logging']['error_level']           = 'verbose';
  $config['system.performance']['css']['preprocess'] = FALSE;
  $config['system.performance']['js']['preprocess']  = FALSE;
  include __DIR__ . '/settings.local.php';
}
// Last: This server specific services file.
if (file_exists(__DIR__ . '/services.local.yml')) {
  $settings['container_yamls'][] = __DIR__ . '/services.local.yml';
}

// Automatically generated include for settings managed by ddev.
$ddev_settings = __DIR__ . '/settings.ddev.php';
if (getenv('IS_DDEV_PROJECT') == 'true' && is_readable($ddev_settings)) {
  require $ddev_settings;
}
