<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* themes/custom/quitpath/templates/paragraph/paragraph--2-col-rows.html.twig */
class __TwigTemplate_3214b38dc1db46e355762e36c3b11842 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'paragraph' => [$this, 'block_paragraph'],
            'content' => [$this, 'block_content'],
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 41
        yield "
";
        // line 43
        $context["classes"] = ["paragraph", ("paragraph--type--" . \Drupal\Component\Utility\Html::getClass(CoreExtension::getAttribute($this->env, $this->source,         // line 45
($context["paragraph"] ?? null), "bundle", [], "any", false, false, true, 45))), ((        // line 46
($context["view_mode"] ?? null)) ? (("paragraph--view-mode--" . \Drupal\Component\Utility\Html::getClass(($context["view_mode"] ?? null)))) : ("")), (( !CoreExtension::getAttribute($this->env, $this->source,         // line 47
($context["paragraph"] ?? null), "isPublished", [], "method", false, false, true, 47)) ? ("paragraph--unpublished") : (""))];
        // line 50
        yield "
";
        // line 51
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_heading_size", [], "any", false, false, true, 51), "value", [], "any", false, false, true, 51) == "h2")) {
            // line 52
            yield "    ";
            $context["heading"] = "h2";
            // line 53
            yield "    ";
            $context["heading_class"] = "text-display-sm font-medium";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source,         // line 54
($context["paragraph"] ?? null), "field_heading_size", [], "any", false, false, true, 54), "value", [], "any", false, false, true, 54) == "h2_large")) {
            // line 55
            yield "    ";
            $context["heading"] = "h2";
            // line 56
            yield "    ";
            $context["heading_class"] = "font-medium";
        } else {
            // line 58
            yield "    ";
            $context["heading"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_heading_size", [], "any", false, false, true, 58), "value", [], "any", false, false, true, 58);
            // line 59
            yield "    ";
            $context["heading_class"] = "font-medium";
        }
        // line 61
        yield "
";
        // line 62
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_space", [], "any", false, false, true, 62), "value", [], "any", false, false, true, 62) == "small")) {
            // line 63
            yield "    ";
            $context["space"] = "pt-10";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source,         // line 64
($context["paragraph"] ?? null), "field_space", [], "any", false, false, true, 64), "value", [], "any", false, false, true, 64) == "medium")) {
            // line 65
            yield "    ";
            $context["space"] = "pt-16";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source,         // line 66
($context["paragraph"] ?? null), "field_space", [], "any", false, false, true, 66), "value", [], "any", false, false, true, 66) == "large")) {
            // line 67
            yield "    ";
            $context["space"] = "pt-25";
        }
        // line 69
        yield "
";
        // line 70
        yield from $this->unwrap()->yieldBlock('paragraph', $context, $blocks);
        // line 90
        yield " 
 
";
        $this->env->getExtension('\Drupal\Core\Template\TwigExtension')
            ->checkDeprecations($context, ["paragraph", "view_mode", "content"]);        yield from [];
    }

    // line 70
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_paragraph(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 71
        yield "    ";
        yield from $this->unwrap()->yieldBlock('content', $context, $blocks);
        yield from [];
    }

    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 72
        yield "        ";
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_background_color", [], "any", false, false, true, 72), "value", [], "any", false, false, true, 72))) {
            // line 73
            yield "            <div class=\"bg-";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_background_color", [], "any", false, false, true, 73), "value", [], "any", false, false, true, 73));
            yield " py-12.5 md:py-25\">
        ";
        }
        // line 75
        yield "        <div class=\"container mx-auto ";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["space"] ?? null), "html", null, true);
        yield "\">
                <div class=\"space-y-2 lg:space-y-10.75\">
                    <div>
                        ";
        // line 78
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title", [], "any", false, false, true, 78), "value", [], "any", false, false, true, 78))) {
            yield "<h2 class=\"font-medium\">";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title", [], "any", false, false, true, 78), "value", [], "any", false, false, true, 78));
            yield "</h2>";
        }
        // line 79
        yield "                    </div>
                    <div class=\"";
        // line 80
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_separate", [], "any", false, false, true, 80), "value", [], "any", false, false, true, 80) == 1)) {
            yield " divide-y ";
        }
        yield " ";
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_add_top_separator", [], "any", false, false, true, 80), "value", [], "any", false, false, true, 80) == 1)) {
            yield " border-t";
        }
        yield " ";
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_add_bottom_separator", [], "any", false, false, true, 80), "value", [], "any", false, false, true, 80) == 1)) {
            yield " border-b";
        }
        yield "\">
                        ";
        // line 81
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["content"] ?? null), "field_rows", [], "any", false, false, true, 81), "html", null, true);
        yield "
                    </div>
                </div>
            </div>
        ";
        // line 85
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_background_color", [], "any", false, false, true, 85), "value", [], "any", false, false, true, 85))) {
            // line 86
            yield "            </div>
        ";
        }
        // line 88
        yield "    ";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "themes/custom/quitpath/templates/paragraph/paragraph--2-col-rows.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  184 => 88,  180 => 86,  178 => 85,  171 => 81,  157 => 80,  154 => 79,  148 => 78,  141 => 75,  135 => 73,  132 => 72,  120 => 71,  113 => 70,  105 => 90,  103 => 70,  100 => 69,  96 => 67,  94 => 66,  91 => 65,  89 => 64,  86 => 63,  84 => 62,  81 => 61,  77 => 59,  74 => 58,  70 => 56,  67 => 55,  65 => 54,  62 => 53,  59 => 52,  57 => 51,  54 => 50,  52 => 47,  51 => 46,  50 => 45,  49 => 43,  46 => 41,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{#
/**
 * @file
 * Default theme implementation to display a paragraph.
 *
 * Available variables:
 * - paragraph: Full paragraph entity.
 *   Only method names starting with \"get\", \"has\", or \"is\" and a few common
 *   methods such as \"id\", \"label\", and \"bundle\" are available. For example:
 *   - paragraph.getCreatedTime() will return the paragraph creation timestamp.
 *   - paragraph.id(): The paragraph ID.
 *   - paragraph.bundle(): The type of the paragraph, for example, \"image\" or \"text\".
 *   - paragraph.getOwnerId(): The user ID of the paragraph author.
 *   See Drupal\\paragraphs\\Entity\\Paragraph for a full list of public properties
 *   and methods for the paragraph object.
 * - content: All paragraph items. Use {{ content }} to print them all,
 *   or print a subset such as {{ content.field_example }}. Use
 *   {{ content|without('field_example') }} to temporarily suppress the printing
 *   of a given child element.
 * - attributes: HTML attributes for the containing element.
 *   The attributes.class element may contain one or more of the following
 *   classes:
 *   - paragraphs: The current template type (also known as a \"theming hook\").
 *   - paragraphs--type-[type]: The current paragraphs type. For example, if the paragraph is an
 *     \"Image\" it would result in \"paragraphs--type--image\". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - paragraphs--view-mode--[view_mode]: The View Mode of the paragraph; for example, a
 *     preview would result in: \"paragraphs--view-mode--preview\", and
 *     default: \"paragraphs--view-mode--default\".
 * - view_mode: View mode; for example, \"preview\" or \"full\".
 * - logged_in: Flag for authenticated user status. Will be true when the
 *   current user is a logged-in member.
 * - is_admin: Flag for admin user status. Will be true when the current user
 *   is an administrator.
 *
 * @see template_preprocess_paragraph()
 *
 * @ingroup themeable
 */
#}

{%
  set classes = [
    'paragraph',
    'paragraph--type--' ~ paragraph.bundle|clean_class,
    view_mode ? 'paragraph--view-mode--' ~ view_mode|clean_class,
    not paragraph.isPublished() ? 'paragraph--unpublished'
  ]
%}

{% if paragraph.field_heading_size.value == 'h2' %}
    {%  set heading = 'h2' %}
    {%  set heading_class = 'text-display-sm font-medium' %}
{% elseif paragraph.field_heading_size.value == 'h2_large' %}
    {%  set heading = 'h2' %}
    {%  set heading_class = 'font-medium' %}
{% else %}
    {%  set heading = paragraph.field_heading_size.value %}
    {%  set heading_class = 'font-medium' %}
{% endif %}

{% if paragraph.field_space.value == 'small' %}
    {%  set space = 'pt-10' %}
{% elseif paragraph.field_space.value == 'medium' %}
    {%  set space = 'pt-16' %}
{% elseif paragraph.field_space.value == 'large' %}
    {%  set space = 'pt-25' %}
{% endif %}

{% block paragraph %}
    {% block content %}
        {% if paragraph.field_background_color.value is not empty %}
            <div class=\"bg-{{ paragraph.field_background_color.value|raw }} py-12.5 md:py-25\">
        {% endif %}
        <div class=\"container mx-auto {{ space }}\">
                <div class=\"space-y-2 lg:space-y-10.75\">
                    <div>
                        {% if paragraph.field_title.value is not empty %}<h2 class=\"font-medium\">{{ paragraph.field_title.value|raw }}</h2>{% endif %}
                    </div>
                    <div class=\"{% if paragraph.field_separate.value == 1 %} divide-y {% endif %} {% if paragraph.field_add_top_separator.value == 1 %} border-t{% endif %} {% if paragraph.field_add_bottom_separator.value == 1 %} border-b{% endif %}\">
                        {{ content.field_rows }}
                    </div>
                </div>
            </div>
        {% if paragraph.field_background_color.value is not empty %}
            </div>
        {% endif %}
    {% endblock %}
{% endblock paragraph %}
 
 
", "themes/custom/quitpath/templates/paragraph/paragraph--2-col-rows.html.twig", "/home/quitpathshareaco/public_html/web/themes/custom/quitpath/templates/paragraph/paragraph--2-col-rows.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["set" => 43, "if" => 51, "block" => 70];
        static $filters = ["clean_class" => 45, "raw" => 73, "escape" => 75];
        static $functions = [];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'if', 'block'],
                ['clean_class', 'raw', 'escape'],
                [],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
