<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* themes/custom/quitpath/templates/paragraph/paragraph--two-column-block-full-width.html.twig */
class __TwigTemplate_4a8b33a0c31778b590a6389ff4110a23 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'paragraph' => [$this, 'block_paragraph'],
            'content' => [$this, 'block_content'],
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 42
        $context["classes"] = ["paragraph", ("paragraph--type--" . \Drupal\Component\Utility\Html::getClass(CoreExtension::getAttribute($this->env, $this->source,         // line 44
($context["paragraph"] ?? null), "bundle", [], "any", false, false, true, 44))), ((        // line 45
($context["view_mode"] ?? null)) ? (("paragraph--view-mode--" . \Drupal\Component\Utility\Html::getClass(($context["view_mode"] ?? null)))) : ("")), (( !CoreExtension::getAttribute($this->env, $this->source,         // line 46
($context["paragraph"] ?? null), "isPublished", [], "method", false, false, true, 46)) ? ("paragraph--unpublished") : (""))];
        // line 49
        yield "
";
        // line 50
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image_alt_text", [], "any", false, false, true, 50), "value", [], "any", false, false, true, 50))) {
            // line 51
            yield "  ";
            $context["alt_text"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image_alt_text", [], "any", false, false, true, 51), "value", [], "any", false, false, true, 51);
        } else {
            // line 53
            yield "  ";
            $context["alt_text"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 53), "entity", [], "any", false, false, true, 53), "field_media_image", [], "any", false, false, true, 53), "alt", [], "any", false, false, true, 53);
        }
        // line 55
        yield "
";
        // line 56
        yield from $this->unwrap()->yieldBlock('paragraph', $context, $blocks);
        // line 81
        yield " 
 
";
        $this->env->getExtension('\Drupal\Core\Template\TwigExtension')
            ->checkDeprecations($context, ["paragraph", "view_mode"]);        yield from [];
    }

    // line 56
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_paragraph(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 57
        yield "    ";
        yield from $this->unwrap()->yieldBlock('content', $context, $blocks);
        yield from [];
    }

    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 58
        yield "        <section class=\"md:pb-25 md:pl-32.5 md:pt-0 md:pr-0\">
            <div class=\"flex max-md:flex-col items-center gap-[37px] md:gap-5 max-md:px-7.5\">
                <div class=\"space-y-2.5 md:space-y-7.5 md:w-1/2 md:pr-9.75\">
                    <h2 class=\"font-medium\">";
        // line 61
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title", [], "any", false, false, true, 61), "value", [], "any", false, false, true, 61));
        yield "</h2>
                    <h6 class=\"max-md:text-display-xs\">";
        // line 62
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_description", [], "any", false, false, true, 62), "value", [], "any", false, false, true, 62));
        yield "</h6>
                    <a href=\"";
        // line 63
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_link", [], "any", false, false, true, 63), "get", [0], "method", false, false, true, 63), "getUrl", [], "method", false, false, true, 63), "toString", [], "method", false, false, true, 63), "html", null, true);
        yield "\" class=\"inline-block py-2.5 px-4.5 rounded-[10px] bg-blue-600 text-white text-md font-semibold max-md:mt-[26px]\">";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_link", [], "any", false, false, true, 63), "title", [], "any", false, false, true, 63), "html", null, true);
        yield "</a>
                    
                </div>
                <div class=\"relative bg-";
        // line 66
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_background_color", [], "any", false, false, true, 66), "value", [], "any", false, false, true, 66));
        yield " rounded-[10px] md:rounded-[10px_0px_0px_10px] w-full md:w-1/2 min-h-101.25 md:min-h-170 justify-end items-end flex\">
                    <img
                        src=\"";
        // line 68
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, $this->extensions['Drupal\Core\Template\TwigExtension']->getFileUrl(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 68), "entity", [], "any", false, false, true, 68), "field_media_image", [], "any", false, false, true, 68), "entity", [], "any", false, false, true, 68), "uri", [], "any", false, false, true, 68), "value", [], "any", false, false, true, 68)), "html", null, true);
        yield "\"
                        class=\"max-md:max-w-50 md:max-w-82 float-end mr-3.75 md:mr-16\"
                        alt=\"";
        // line 70
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["alt_text"] ?? null), "html", null, true);
        yield "\"
                    />
                    <h5 class=\"absolute text-white font-normal bottom-0 max-md:left-[27px] md:px-14 py-[23px] md:py-10 max-md:text-sm max-md:w-[274px]\">
                        ";
        // line 73
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image_overlay_text", [], "any", false, false, true, 73), "value", [], "any", false, false, true, 73));
        yield "
                    </h5>
                </div>
            </div>
        </section>

    ";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "themes/custom/quitpath/templates/paragraph/paragraph--two-column-block-full-width.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  133 => 73,  127 => 70,  122 => 68,  117 => 66,  109 => 63,  105 => 62,  101 => 61,  96 => 58,  84 => 57,  77 => 56,  69 => 81,  67 => 56,  64 => 55,  60 => 53,  56 => 51,  54 => 50,  51 => 49,  49 => 46,  48 => 45,  47 => 44,  46 => 42,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{#
/**
 * @file
 * Default theme implementation to display a paragraph.
 *
 * Available variables:
 * - paragraph: Full paragraph entity.
 *   Only method names starting with \"get\", \"has\", or \"is\" and a few common
 *   methods such as \"id\", \"label\", and \"bundle\" are available. For example:
 *   - paragraph.getCreatedTime() will return the paragraph creation timestamp.
 *   - paragraph.id(): The paragraph ID.
 *   - paragraph.bundle(): The type of the paragraph, for example, \"image\" or \"text\".
 *   - paragraph.getOwnerId(): The user ID of the paragraph author.
 *   See Drupal\\paragraphs\\Entity\\Paragraph for a full list of public properties
 *   and methods for the paragraph object.
 * - content: All paragraph items. Use {{ content }} to print them all,
 *   or print a subset such as {{ content.field_example }}. Use
 *   {{ content|without('field_example') }} to temporarily suppress the printing
 *   of a given child element.
 * - attributes: HTML attributes for the containing element.
 *   The attributes.class element may contain one or more of the following
 *   classes:
 *   - paragraphs: The current template type (also known as a \"theming hook\").
 *   - paragraphs--type-[type]: The current paragraphs type. For example, if the paragraph is an
 *     \"Image\" it would result in \"paragraphs--type--image\". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - paragraphs--view-mode--[view_mode]: The View Mode of the paragraph; for example, a
 *     preview would result in: \"paragraphs--view-mode--preview\", and
 *     default: \"paragraphs--view-mode--default\".
 * - view_mode: View mode; for example, \"preview\" or \"full\".
 * - logged_in: Flag for authenticated user status. Will be true when the
 *   current user is a logged-in member.
 * - is_admin: Flag for admin user status. Will be true when the current user
 *   is an administrator.
 *
 * @see template_preprocess_paragraph()
 *
 * @ingroup themeable
 */
#}
{%
  set classes = [
    'paragraph',
    'paragraph--type--' ~ paragraph.bundle|clean_class,
    view_mode ? 'paragraph--view-mode--' ~ view_mode|clean_class,
    not paragraph.isPublished() ? 'paragraph--unpublished'
  ]
%}

{% if paragraph.field_image_alt_text.value is not empty %}
  {% set alt_text =  paragraph.field_image_alt_text.value  %}
{% else %}
  {% set alt_text =  paragraph.field_image.entity.field_media_image.alt  %}
{% endif %}

{% block paragraph %}
    {% block content %}
        <section class=\"md:pb-25 md:pl-32.5 md:pt-0 md:pr-0\">
            <div class=\"flex max-md:flex-col items-center gap-[37px] md:gap-5 max-md:px-7.5\">
                <div class=\"space-y-2.5 md:space-y-7.5 md:w-1/2 md:pr-9.75\">
                    <h2 class=\"font-medium\">{{ paragraph.field_title.value|raw }}</h2>
                    <h6 class=\"max-md:text-display-xs\">{{ paragraph.field_description.value|raw }}</h6>
                    <a href=\"{{ paragraph.field_link.get(0).getUrl().toString() }}\" class=\"inline-block py-2.5 px-4.5 rounded-[10px] bg-blue-600 text-white text-md font-semibold max-md:mt-[26px]\">{{ paragraph.field_link.title }}</a>
                    
                </div>
                <div class=\"relative bg-{{ paragraph.field_background_color.value|raw }} rounded-[10px] md:rounded-[10px_0px_0px_10px] w-full md:w-1/2 min-h-101.25 md:min-h-170 justify-end items-end flex\">
                    <img
                        src=\"{{ file_url(paragraph.field_image.entity.field_media_image.entity.uri.value) }}\"
                        class=\"max-md:max-w-50 md:max-w-82 float-end mr-3.75 md:mr-16\"
                        alt=\"{{ alt_text }}\"
                    />
                    <h5 class=\"absolute text-white font-normal bottom-0 max-md:left-[27px] md:px-14 py-[23px] md:py-10 max-md:text-sm max-md:w-[274px]\">
                        {{ paragraph.field_image_overlay_text.value|raw }}
                    </h5>
                </div>
            </div>
        </section>

    {% endblock %}
{% endblock paragraph %}
 
 
", "themes/custom/quitpath/templates/paragraph/paragraph--two-column-block-full-width.html.twig", "/home/quitpathshareaco/public_html/web/themes/custom/quitpath/templates/paragraph/paragraph--two-column-block-full-width.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["set" => 42, "if" => 50, "block" => 56];
        static $filters = ["clean_class" => 44, "raw" => 61, "escape" => 63];
        static $functions = ["file_url" => 68];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'if', 'block'],
                ['clean_class', 'raw', 'escape'],
                ['file_url'],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
