<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* themes/custom/quitpath/templates/paragraph/paragraph--2-col-rows.html.twig */
class __TwigTemplate_3214b38dc1db46e355762e36c3b11842 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'paragraph' => [$this, 'block_paragraph'],
            'content' => [$this, 'block_content'],
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 41
        yield "
";
        // line 43
        $context["classes"] = ["paragraph", ("paragraph--type--" . \Drupal\Component\Utility\Html::getClass(CoreExtension::getAttribute($this->env, $this->source,         // line 45
($context["paragraph"] ?? null), "bundle", [], "any", false, false, true, 45))), ((        // line 46
($context["view_mode"] ?? null)) ? (("paragraph--view-mode--" . \Drupal\Component\Utility\Html::getClass(($context["view_mode"] ?? null)))) : ("")), (( !CoreExtension::getAttribute($this->env, $this->source,         // line 47
($context["paragraph"] ?? null), "isPublished", [], "method", false, false, true, 47)) ? ("paragraph--unpublished") : (""))];
        // line 50
        yield "
";
        // line 61
        yield "
";
        // line 62
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_tags", [], "any", false, false, true, 62), "value", [], "any", false, false, true, 62))) {
            // line 63
            yield "    ";
            $context["title_heading"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_tags", [], "any", false, false, true, 63), "value", [], "any", false, false, true, 63);
        } else {
            // line 65
            yield "    ";
            $context["title_heading"] = "h2";
        }
        // line 67
        yield "
";
        // line 68
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_size_weight", [], "any", false, false, true, 68), "value", [], "any", false, false, true, 68))) {
            // line 69
            yield "    ";
            $context["heading_class"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_size_weight", [], "any", false, false, true, 69), "value", [], "any", false, false, true, 69);
        } else {
            // line 71
            yield "    ";
            $context["heading_class"] = "font-medium";
        }
        // line 73
        yield "

";
        // line 75
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_space", [], "any", false, false, true, 75), "value", [], "any", false, false, true, 75) == "small")) {
            // line 76
            yield "    ";
            $context["space"] = "pt-10";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source,         // line 77
($context["paragraph"] ?? null), "field_space", [], "any", false, false, true, 77), "value", [], "any", false, false, true, 77) == "medium")) {
            // line 78
            yield "    ";
            $context["space"] = "pt-16";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source,         // line 79
($context["paragraph"] ?? null), "field_space", [], "any", false, false, true, 79), "value", [], "any", false, false, true, 79) == "large")) {
            // line 80
            yield "    ";
            $context["space"] = "pt-25";
        }
        // line 82
        yield "
";
        // line 83
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_alignment", [], "any", false, false, true, 83), "value", [], "any", false, false, true, 83) == "left")) {
            // line 84
            yield "    ";
            $context["alignment"] = "text-left";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source,         // line 85
($context["paragraph"] ?? null), "field_title_alignment", [], "any", false, false, true, 85), "value", [], "any", false, false, true, 85) == "center")) {
            // line 86
            yield "    ";
            $context["alignment"] = "text-center";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source,         // line 87
($context["paragraph"] ?? null), "field_title_alignment", [], "any", false, false, true, 87), "value", [], "any", false, false, true, 87) == "right")) {
            // line 88
            yield "    ";
            $context["alignment"] = "text-right";
        }
        // line 90
        yield "
";
        // line 91
        yield from $this->unwrap()->yieldBlock('paragraph', $context, $blocks);
        // line 111
        yield " 
 
";
        $this->env->getExtension('\Drupal\Core\Template\TwigExtension')
            ->checkDeprecations($context, ["paragraph", "view_mode", "content"]);        yield from [];
    }

    // line 91
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_paragraph(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 92
        yield "    ";
        yield from $this->unwrap()->yieldBlock('content', $context, $blocks);
        yield from [];
    }

    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 93
        yield "        ";
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_background_color", [], "any", false, false, true, 93), "value", [], "any", false, false, true, 93))) {
            // line 94
            yield "            <div class=\"bg-";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_background_color", [], "any", false, false, true, 94), "value", [], "any", false, false, true, 94));
            yield " py-12.5 md:py-25\">
        ";
        }
        // line 96
        yield "        <div class=\"container mx-auto ";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["space"] ?? null), "html", null, true);
        yield "\">
                <div class=\"space-y-2 lg:space-y-10.75\">
                    <div>
                        ";
        // line 99
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title", [], "any", false, false, true, 99), "value", [], "any", false, false, true, 99))) {
            yield "<";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["title_heading"] ?? null), "html", null, true);
            yield " class=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["heading_class"] ?? null), "html", null, true);
            yield " ";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["alignment"] ?? null), "html", null, true);
            yield "\">";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title", [], "any", false, false, true, 99), "value", [], "any", false, false, true, 99));
            yield "</";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["title_heading"] ?? null), "html", null, true);
            yield ">";
        }
        // line 100
        yield "                    </div>
                    <div class=\"";
        // line 101
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_separate", [], "any", false, false, true, 101), "value", [], "any", false, false, true, 101) == 1)) {
            yield " divide-y ";
        }
        yield " ";
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_add_top_separator", [], "any", false, false, true, 101), "value", [], "any", false, false, true, 101) == 1)) {
            yield " border-t";
        }
        yield " ";
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_add_bottom_separator", [], "any", false, false, true, 101), "value", [], "any", false, false, true, 101) == 1)) {
            yield " border-b";
        }
        yield "\">
                        ";
        // line 102
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["content"] ?? null), "field_rows", [], "any", false, false, true, 102), "html", null, true);
        yield "
                    </div>
                </div>
            </div>
        ";
        // line 106
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_background_color", [], "any", false, false, true, 106), "value", [], "any", false, false, true, 106))) {
            // line 107
            yield "            </div>
        ";
        }
        // line 109
        yield "    ";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "themes/custom/quitpath/templates/paragraph/paragraph--2-col-rows.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  214 => 109,  210 => 107,  208 => 106,  201 => 102,  187 => 101,  184 => 100,  170 => 99,  163 => 96,  157 => 94,  154 => 93,  142 => 92,  135 => 91,  127 => 111,  125 => 91,  122 => 90,  118 => 88,  116 => 87,  113 => 86,  111 => 85,  108 => 84,  106 => 83,  103 => 82,  99 => 80,  97 => 79,  94 => 78,  92 => 77,  89 => 76,  87 => 75,  83 => 73,  79 => 71,  75 => 69,  73 => 68,  70 => 67,  66 => 65,  62 => 63,  60 => 62,  57 => 61,  54 => 50,  52 => 47,  51 => 46,  50 => 45,  49 => 43,  46 => 41,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{#
/**
 * @file
 * Default theme implementation to display a paragraph.
 *
 * Available variables:
 * - paragraph: Full paragraph entity.
 *   Only method names starting with \"get\", \"has\", or \"is\" and a few common
 *   methods such as \"id\", \"label\", and \"bundle\" are available. For example:
 *   - paragraph.getCreatedTime() will return the paragraph creation timestamp.
 *   - paragraph.id(): The paragraph ID.
 *   - paragraph.bundle(): The type of the paragraph, for example, \"image\" or \"text\".
 *   - paragraph.getOwnerId(): The user ID of the paragraph author.
 *   See Drupal\\paragraphs\\Entity\\Paragraph for a full list of public properties
 *   and methods for the paragraph object.
 * - content: All paragraph items. Use {{ content }} to print them all,
 *   or print a subset such as {{ content.field_example }}. Use
 *   {{ content|without('field_example') }} to temporarily suppress the printing
 *   of a given child element.
 * - attributes: HTML attributes for the containing element.
 *   The attributes.class element may contain one or more of the following
 *   classes:
 *   - paragraphs: The current template type (also known as a \"theming hook\").
 *   - paragraphs--type-[type]: The current paragraphs type. For example, if the paragraph is an
 *     \"Image\" it would result in \"paragraphs--type--image\". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - paragraphs--view-mode--[view_mode]: The View Mode of the paragraph; for example, a
 *     preview would result in: \"paragraphs--view-mode--preview\", and
 *     default: \"paragraphs--view-mode--default\".
 * - view_mode: View mode; for example, \"preview\" or \"full\".
 * - logged_in: Flag for authenticated user status. Will be true when the
 *   current user is a logged-in member.
 * - is_admin: Flag for admin user status. Will be true when the current user
 *   is an administrator.
 *
 * @see template_preprocess_paragraph()
 *
 * @ingroup themeable
 */
#}

{%
  set classes = [
    'paragraph',
    'paragraph--type--' ~ paragraph.bundle|clean_class,
    view_mode ? 'paragraph--view-mode--' ~ view_mode|clean_class,
    not paragraph.isPublished() ? 'paragraph--unpublished'
  ]
%}

{#{% if paragraph.field_heading_size.value == 'h2' %}#}
{#    {%  set heading = 'h2' %}#}
{#    {%  set heading_class = 'text-display-sm font-medium' %}#}
{#{% elseif paragraph.field_heading_size.value == 'h2_large' %}#}
{#    {%  set heading = 'h2' %}#}
{#    {%  set heading_class = 'font-medium' %}#}
{#{% else %}#}
{#    {%  set heading = paragraph.field_heading_size.value %}#}
{#    {%  set heading_class = 'font-medium' %}#}
{#{% endif %}#}

{% if paragraph.field_title_tags.value is not empty %}
    {% set title_heading =  paragraph.field_title_tags.value  %}
{% else %}
    {% set title_heading =  'h2'  %}
{% endif %}

{% if paragraph.field_title_size_weight.value is not empty %}
    {% set heading_class =  paragraph.field_title_size_weight.value  %}
{% else %}
    {% set heading_class =  'font-medium'  %}
{% endif %}


{% if paragraph.field_space.value == 'small' %}
    {%  set space = 'pt-10' %}
{% elseif paragraph.field_space.value == 'medium' %}
    {%  set space = 'pt-16' %}
{% elseif paragraph.field_space.value == 'large' %}
    {%  set space = 'pt-25' %}
{% endif %}

{% if paragraph.field_title_alignment.value == \"left\" %}
    {% set alignment = \"text-left\" %}
{% elseif paragraph.field_title_alignment.value == \"center\" %}
    {% set alignment = \"text-center\" %}
{% elseif paragraph.field_title_alignment.value == \"right\" %}
    {% set alignment = \"text-right\" %}
{% endif %}

{% block paragraph %}
    {% block content %}
        {% if paragraph.field_background_color.value is not empty %}
            <div class=\"bg-{{ paragraph.field_background_color.value|raw }} py-12.5 md:py-25\">
        {% endif %}
        <div class=\"container mx-auto {{ space }}\">
                <div class=\"space-y-2 lg:space-y-10.75\">
                    <div>
                        {% if paragraph.field_title.value is not empty %}<{{ title_heading }} class=\"{{ heading_class }} {{ alignment }}\">{{ paragraph.field_title.value|raw }}</{{ title_heading }}>{% endif %}
                    </div>
                    <div class=\"{% if paragraph.field_separate.value == 1 %} divide-y {% endif %} {% if paragraph.field_add_top_separator.value == 1 %} border-t{% endif %} {% if paragraph.field_add_bottom_separator.value == 1 %} border-b{% endif %}\">
                        {{ content.field_rows }}
                    </div>
                </div>
            </div>
        {% if paragraph.field_background_color.value is not empty %}
            </div>
        {% endif %}
    {% endblock %}
{% endblock paragraph %}
 
 
", "themes/custom/quitpath/templates/paragraph/paragraph--2-col-rows.html.twig", "/home/quitpathshareaco/public_html/web/themes/custom/quitpath/templates/paragraph/paragraph--2-col-rows.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["set" => 43, "if" => 62, "block" => 91];
        static $filters = ["clean_class" => 45, "raw" => 94, "escape" => 96];
        static $functions = [];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'if', 'block'],
                ['clean_class', 'raw', 'escape'],
                [],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
