<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* themes/custom/quitpath/templates/paragraph/paragraph--cta-block-text-section--default.html.twig */
class __TwigTemplate_15fcac244adfe550b395794dcd286dbb extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'paragraph' => [$this, 'block_paragraph'],
            'content' => [$this, 'block_content'],
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 42
        $context["classes"] = ["paragraph", ("paragraph--type--" . \Drupal\Component\Utility\Html::getClass(CoreExtension::getAttribute($this->env, $this->source,         // line 44
($context["paragraph"] ?? null), "bundle", [], "any", false, false, true, 44))), ((        // line 45
($context["view_mode"] ?? null)) ? (("paragraph--view-mode--" . \Drupal\Component\Utility\Html::getClass(($context["view_mode"] ?? null)))) : ("")), (( !CoreExtension::getAttribute($this->env, $this->source,         // line 46
($context["paragraph"] ?? null), "isPublished", [], "method", false, false, true, 46)) ? ("paragraph--unpublished") : (""))];
        // line 49
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_tags", [], "any", false, false, true, 49), "value", [], "any", false, false, true, 49))) {
            // line 50
            yield "    ";
            $context["title_heading"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_tags", [], "any", false, false, true, 50), "value", [], "any", false, false, true, 50);
        } else {
            // line 52
            yield "    ";
            $context["title_heading"] = "h2";
        }
        // line 54
        yield "
";
        // line 55
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_size_weight", [], "any", false, false, true, 55), "value", [], "any", false, false, true, 55))) {
            // line 56
            yield "    ";
            $context["heading_class"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_size_weight", [], "any", false, false, true, 56), "value", [], "any", false, false, true, 56);
        } else {
            // line 58
            yield "    ";
            $context["heading_class"] = "font-medium";
        }
        // line 60
        yield "
";
        // line 61
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_heading", [], "any", false, false, true, 61), "value", [], "any", false, false, true, 61))) {
            // line 62
            yield "    ";
            $context["sub_title_heading"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_heading", [], "any", false, false, true, 62), "value", [], "any", false, false, true, 62);
        } else {
            // line 64
            yield "    ";
            $context["sub_title_heading"] = "p";
        }
        // line 66
        yield "
";
        // line 67
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_size_weight", [], "any", false, false, true, 67), "value", [], "any", false, false, true, 67))) {
            // line 68
            yield "    ";
            $context["sub_heading_class"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_size_weight", [], "any", false, false, true, 68), "value", [], "any", false, false, true, 68);
        } else {
            // line 70
            yield "    ";
            $context["sub_heading_class"] = "text-display-sm";
        }
        // line 72
        yield "
";
        // line 73
        yield from $this->unwrap()->yieldBlock('paragraph', $context, $blocks);
        // line 96
        yield " 
 
";
        $this->env->getExtension('\Drupal\Core\Template\TwigExtension')
            ->checkDeprecations($context, ["paragraph", "view_mode", "content"]);        yield from [];
    }

    // line 73
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_paragraph(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 74
        yield "    ";
        yield from $this->unwrap()->yieldBlock('content', $context, $blocks);
        yield from [];
    }

    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 75
        yield "        <section class=\"pb-0\">
            <div class=\"container mx-auto\">
                ";
        // line 77
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title", [], "any", false, false, true, 77), "value", [], "any", false, false, true, 77))) {
            yield "<";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["title_heading"] ?? null), "html", null, true);
            yield " class=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["heading_class"] ?? null), "html", null, true);
            yield " pb-10\">";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title", [], "any", false, false, true, 77), "value", [], "any", false, false, true, 77));
            yield "</";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["title_heading"] ?? null), "html", null, true);
            yield ">";
        }
        // line 78
        yield "                ";
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_sub_title", [], "any", false, false, true, 78), "value", [], "any", false, false, true, 78))) {
            yield "<";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["sub_title_heading"] ?? null), "html", null, true);
            yield " class=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["sub_heading_class"] ?? null), "html", null, true);
            yield " pb-10\">";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_sub_title", [], "any", false, false, true, 78), "value", [], "any", false, false, true, 78));
            yield "</";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["sub_title_heading"] ?? null), "html", null, true);
            yield ">";
        }
        // line 79
        yield "                ";
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_column_type", [], "any", false, false, true, 79), "value", [], "any", false, false, true, 79) == "3_column")) {
            // line 80
            yield "                    <div class=\"grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-5\">
                        ";
            // line 81
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["content"] ?? null), "field_cta_block_text", [], "any", false, false, true, 81), "html", null, true);
            yield "
                        
                    </div>
                ";
        }
        // line 85
        yield "                ";
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_column_type", [], "any", false, false, true, 85), "value", [], "any", false, false, true, 85) == "2_column")) {
            // line 86
            yield "                    <div class=\"grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-5\">
                        ";
            // line 87
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, ($context["content"] ?? null), "field_cta_block_text", [], "any", false, false, true, 87), "html", null, true);
            yield "
                        
                    </div>
                ";
        }
        // line 91
        yield "            </div>
        </section>

    ";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "themes/custom/quitpath/templates/paragraph/paragraph--cta-block-text-section--default.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  187 => 91,  180 => 87,  177 => 86,  174 => 85,  167 => 81,  164 => 80,  161 => 79,  148 => 78,  136 => 77,  132 => 75,  120 => 74,  113 => 73,  105 => 96,  103 => 73,  100 => 72,  96 => 70,  92 => 68,  90 => 67,  87 => 66,  83 => 64,  79 => 62,  77 => 61,  74 => 60,  70 => 58,  66 => 56,  64 => 55,  61 => 54,  57 => 52,  53 => 50,  51 => 49,  49 => 46,  48 => 45,  47 => 44,  46 => 42,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{#
/**
 * @file
 * Default theme implementation to display a paragraph.
 *
 * Available variables:
 * - paragraph: Full paragraph entity.
 *   Only method names starting with \"get\", \"has\", or \"is\" and a few common
 *   methods such as \"id\", \"label\", and \"bundle\" are available. For example:
 *   - paragraph.getCreatedTime() will return the paragraph creation timestamp.
 *   - paragraph.id(): The paragraph ID.
 *   - paragraph.bundle(): The type of the paragraph, for example, \"image\" or \"text\".
 *   - paragraph.getOwnerId(): The user ID of the paragraph author.
 *   See Drupal\\paragraphs\\Entity\\Paragraph for a full list of public properties
 *   and methods for the paragraph object.
 * - content: All paragraph items. Use {{ content }} to print them all,
 *   or print a subset such as {{ content.field_example }}. Use
 *   {{ content|without('field_example') }} to temporarily suppress the printing
 *   of a given child element.
 * - attributes: HTML attributes for the containing element.
 *   The attributes.class element may contain one or more of the following
 *   classes:
 *   - paragraphs: The current template type (also known as a \"theming hook\").
 *   - paragraphs--type-[type]: The current paragraphs type. For example, if the paragraph is an
 *     \"Image\" it would result in \"paragraphs--type--image\". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - paragraphs--view-mode--[view_mode]: The View Mode of the paragraph; for example, a
 *     preview would result in: \"paragraphs--view-mode--preview\", and
 *     default: \"paragraphs--view-mode--default\".
 * - view_mode: View mode; for example, \"preview\" or \"full\".
 * - logged_in: Flag for authenticated user status. Will be true when the
 *   current user is a logged-in member.
 * - is_admin: Flag for admin user status. Will be true when the current user
 *   is an administrator.
 *
 * @see template_preprocess_paragraph()
 *
 * @ingroup themeable
 */
#}
{%
  set classes = [
    'paragraph',
    'paragraph--type--' ~ paragraph.bundle|clean_class,
    view_mode ? 'paragraph--view-mode--' ~ view_mode|clean_class,
    not paragraph.isPublished() ? 'paragraph--unpublished'
  ]
%}
{% if paragraph.field_title_tags.value is not empty %}
    {% set title_heading =  paragraph.field_title_tags.value  %}
{% else %}
    {% set title_heading =  'h2'  %}
{% endif %}

{% if paragraph.field_title_size_weight.value is not empty %}
    {% set heading_class =  paragraph.field_title_size_weight.value  %}
{% else %}
    {% set heading_class =  'font-medium'  %}
{% endif %}

{% if paragraph.field_heading.value is not empty %}
    {% set sub_title_heading =  paragraph.field_heading.value  %}
{% else %}
    {% set sub_title_heading =  'p'  %}
{% endif %}

{% if paragraph.field_size_weight.value is not empty %}
    {% set sub_heading_class =  paragraph.field_size_weight.value  %}
{% else %}
    {% set sub_heading_class =  'text-display-sm'  %}
{% endif %}

{% block paragraph %}
    {% block content %}
        <section class=\"pb-0\">
            <div class=\"container mx-auto\">
                {% if paragraph.field_title.value is not empty %}<{{ title_heading }} class=\"{{ heading_class }} pb-10\">{{ paragraph.field_title.value|raw }}</{{ title_heading }}>{% endif %}
                {% if paragraph.field_sub_title.value is not empty %}<{{ sub_title_heading }} class=\"{{ sub_heading_class }} pb-10\">{{ paragraph.field_sub_title.value|raw }}</{{ sub_title_heading }}>{% endif %}
                {% if paragraph.field_column_type.value == \"3_column\" %}
                    <div class=\"grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-5\">
                        {{ content.field_cta_block_text }}
                        
                    </div>
                {% endif %}
                {% if paragraph.field_column_type.value == \"2_column\" %}
                    <div class=\"grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-5\">
                        {{ content.field_cta_block_text }}
                        
                    </div>
                {% endif %}
            </div>
        </section>

    {% endblock %}
{% endblock paragraph %}
 
 
", "themes/custom/quitpath/templates/paragraph/paragraph--cta-block-text-section--default.html.twig", "/home/quitpathshareaco/public_html/web/themes/custom/quitpath/templates/paragraph/paragraph--cta-block-text-section--default.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["set" => 42, "if" => 49, "block" => 73];
        static $filters = ["clean_class" => 44, "escape" => 77, "raw" => 77];
        static $functions = [];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'if', 'block'],
                ['clean_class', 'escape', 'raw'],
                [],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
