<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* themes/custom/quitpath/templates/paragraph/paragraph--health-center.html.twig */
class __TwigTemplate_2dcf1d9b194589fef06eaaff608ec6c6 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'paragraph' => [$this, 'block_paragraph'],
            'content' => [$this, 'block_content'],
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 42
        $context["classes"] = ["paragraph", ("paragraph--type--" . \Drupal\Component\Utility\Html::getClass(CoreExtension::getAttribute($this->env, $this->source,         // line 44
($context["paragraph"] ?? null), "bundle", [], "any", false, false, true, 44))), ((        // line 45
($context["view_mode"] ?? null)) ? (("paragraph--view-mode--" . \Drupal\Component\Utility\Html::getClass(($context["view_mode"] ?? null)))) : ("")), (( !CoreExtension::getAttribute($this->env, $this->source,         // line 46
($context["paragraph"] ?? null), "isPublished", [], "method", false, false, true, 46)) ? ("paragraph--unpublished") : (""))];
        // line 49
        yield "
";
        // line 50
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_tags", [], "any", false, false, true, 50), "value", [], "any", false, false, true, 50))) {
            // line 51
            yield "    ";
            $context["title_heading"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_tags", [], "any", false, false, true, 51), "value", [], "any", false, false, true, 51);
        } else {
            // line 53
            yield "    ";
            $context["title_heading"] = "h5";
        }
        // line 55
        yield "
";
        // line 56
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_size_weight", [], "any", false, false, true, 56), "value", [], "any", false, false, true, 56))) {
            // line 57
            yield "    ";
            $context["heading_class"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_size_weight", [], "any", false, false, true, 57), "value", [], "any", false, false, true, 57);
        } else {
            // line 59
            yield "    ";
            $context["heading_class"] = "font-medium";
        }
        // line 61
        yield "

";
        // line 63
        yield from $this->unwrap()->yieldBlock('paragraph', $context, $blocks);
        // line 81
        yield " 
 
";
        $this->env->getExtension('\Drupal\Core\Template\TwigExtension')
            ->checkDeprecations($context, ["paragraph", "view_mode"]);        yield from [];
    }

    // line 63
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_paragraph(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 64
        yield "    ";
        yield from $this->unwrap()->yieldBlock('content', $context, $blocks);
        yield from [];
    }

    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 65
        yield "        <div class=\"bg-white rounded-[10px] p-7.5 space-y-2.5\">
            <div>
                <";
        // line 67
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["title_heading"] ?? null), "html", null, true);
        yield " class=\"";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["heading_class"] ?? null), "html", null, true);
        yield "\">";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title", [], "any", false, false, true, 67), "value", [], "any", false, false, true, 67));
        yield "</";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["title_heading"] ?? null), "html", null, true);
        yield ">
            </div>
            <div>
                <h4 class=\"s24-w400\"><b>";
        // line 70
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Address"));
        yield ":</b></h4>
                ";
        // line 71
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_address", [], "any", false, false, true, 71), "value", [], "any", false, false, true, 71));
        yield "
            </div>
            <div>
                <h4 class=\"s24-w400\"><b>";
        // line 74
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Phone"));
        yield ": </b><a href=\"tel: ";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_phone", [], "any", false, false, true, 74), "value", [], "any", false, false, true, 74));
        yield "\">";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_phone", [], "any", false, false, true, 74), "value", [], "any", false, false, true, 74));
        yield "</a></h4>
                <h4 class=\"s24-w400\"><b>";
        // line 75
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Hours"));
        yield ": </b>";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_hours", [], "any", false, false, true, 75), "value", [], "any", false, false, true, 75));
        yield "</h4>
            </div>
        </div>

    ";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "themes/custom/quitpath/templates/paragraph/paragraph--health-center.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  144 => 75,  136 => 74,  130 => 71,  126 => 70,  114 => 67,  110 => 65,  98 => 64,  91 => 63,  83 => 81,  81 => 63,  77 => 61,  73 => 59,  69 => 57,  67 => 56,  64 => 55,  60 => 53,  56 => 51,  54 => 50,  51 => 49,  49 => 46,  48 => 45,  47 => 44,  46 => 42,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{#
/**
 * @file
 * Default theme implementation to display a paragraph.
 *
 * Available variables:
 * - paragraph: Full paragraph entity.
 *   Only method names starting with \"get\", \"has\", or \"is\" and a few common
 *   methods such as \"id\", \"label\", and \"bundle\" are available. For example:
 *   - paragraph.getCreatedTime() will return the paragraph creation timestamp.
 *   - paragraph.id(): The paragraph ID.
 *   - paragraph.bundle(): The type of the paragraph, for example, \"image\" or \"text\".
 *   - paragraph.getOwnerId(): The user ID of the paragraph author.
 *   See Drupal\\paragraphs\\Entity\\Paragraph for a full list of public properties
 *   and methods for the paragraph object.
 * - content: All paragraph items. Use {{ content }} to print them all,
 *   or print a subset such as {{ content.field_example }}. Use
 *   {{ content|without('field_example') }} to temporarily suppress the printing
 *   of a given child element.
 * - attributes: HTML attributes for the containing element.
 *   The attributes.class element may contain one or more of the following
 *   classes:
 *   - paragraphs: The current template type (also known as a \"theming hook\").
 *   - paragraphs--type-[type]: The current paragraphs type. For example, if the paragraph is an
 *     \"Image\" it would result in \"paragraphs--type--image\". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - paragraphs--view-mode--[view_mode]: The View Mode of the paragraph; for example, a
 *     preview would result in: \"paragraphs--view-mode--preview\", and
 *     default: \"paragraphs--view-mode--default\".
 * - view_mode: View mode; for example, \"preview\" or \"full\".
 * - logged_in: Flag for authenticated user status. Will be true when the
 *   current user is a logged-in member.
 * - is_admin: Flag for admin user status. Will be true when the current user
 *   is an administrator.
 *
 * @see template_preprocess_paragraph()
 *
 * @ingroup themeable
 */
#}
{%
  set classes = [
    'paragraph',
    'paragraph--type--' ~ paragraph.bundle|clean_class,
    view_mode ? 'paragraph--view-mode--' ~ view_mode|clean_class,
    not paragraph.isPublished() ? 'paragraph--unpublished'
  ]
%}

{% if paragraph.field_title_tags.value is not empty %}
    {% set title_heading =  paragraph.field_title_tags.value  %}
{% else %}
    {% set title_heading =  'h5'  %}
{% endif %}

{% if paragraph.field_title_size_weight.value is not empty %}
    {% set heading_class =  paragraph.field_title_size_weight.value  %}
{% else %}
    {% set heading_class =  'font-medium'  %}
{% endif %}


{% block paragraph %}
    {% block content %}
        <div class=\"bg-white rounded-[10px] p-7.5 space-y-2.5\">
            <div>
                <{{ title_heading }} class=\"{{ heading_class }}\">{{ paragraph.field_title.value|raw }}</{{ title_heading }}>
            </div>
            <div>
                <h4 class=\"s24-w400\"><b>{{ 'Address'|t }}:</b></h4>
                {{ paragraph.field_address.value|raw }}
            </div>
            <div>
                <h4 class=\"s24-w400\"><b>{{ 'Phone'|t }}: </b><a href=\"tel: {{ paragraph.field_phone.value|raw }}\">{{ paragraph.field_phone.value|raw }}</a></h4>
                <h4 class=\"s24-w400\"><b>{{ 'Hours'|t }}: </b>{{ paragraph.field_hours.value|raw }}</h4>
            </div>
        </div>

    {% endblock %}
{% endblock paragraph %}
 
 
", "themes/custom/quitpath/templates/paragraph/paragraph--health-center.html.twig", "/home/quitpathshareaco/public_html/web/themes/custom/quitpath/templates/paragraph/paragraph--health-center.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["set" => 42, "if" => 50, "block" => 63];
        static $filters = ["clean_class" => 44, "escape" => 67, "raw" => 67, "t" => 70];
        static $functions = [];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'if', 'block'],
                ['clean_class', 'escape', 'raw', 't'],
                [],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
