<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* themes/custom/quitpath/templates/paragraph/paragraph--rows.html.twig */
class __TwigTemplate_b71ccc66ff4868dc83d876a77317b63c extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'paragraph' => [$this, 'block_paragraph'],
            'content' => [$this, 'block_content'],
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 41
        yield "
";
        // line 43
        $context["classes"] = ["paragraph", ("paragraph--type--" . \Drupal\Component\Utility\Html::getClass(CoreExtension::getAttribute($this->env, $this->source,         // line 45
($context["paragraph"] ?? null), "bundle", [], "any", false, false, true, 45))), ((        // line 46
($context["view_mode"] ?? null)) ? (("paragraph--view-mode--" . \Drupal\Component\Utility\Html::getClass(($context["view_mode"] ?? null)))) : ("")), (( !CoreExtension::getAttribute($this->env, $this->source,         // line 47
($context["paragraph"] ?? null), "isPublished", [], "method", false, false, true, 47)) ? ("paragraph--unpublished") : (""))];
        // line 50
        yield "
";
        // line 51
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_size", [], "any", false, false, true, 51), "value", [], "any", false, false, true, 51) == "25_75")) {
            // line 52
            yield "    ";
            $context["first_class"] = "lg:w-3/12";
            // line 53
            yield "    ";
            $context["second_class"] = "lg:w-9/12";
        }
        // line 55
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_size", [], "any", false, false, true, 55), "value", [], "any", false, false, true, 55) == "33_66")) {
            // line 56
            yield "    ";
            $context["first_class"] = "lg:w-4/12";
            // line 57
            yield "    ";
            $context["second_class"] = "lg:w-8/12";
        }
        // line 59
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_size", [], "any", false, false, true, 59), "value", [], "any", false, false, true, 59) == "40_60")) {
            // line 60
            yield "    ";
            $context["first_class"] = "lg:w-5/12";
            // line 61
            yield "    ";
            $context["second_class"] = "lg:w-7/12";
        }
        // line 63
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_size", [], "any", false, false, true, 63), "value", [], "any", false, false, true, 63) == "50_50")) {
            // line 64
            yield "    ";
            $context["first_class"] = "lg:w-1/2";
            // line 65
            yield "    ";
            $context["second_class"] = "lg:w-1/2";
        }
        // line 67
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_size", [], "any", false, false, true, 67), "value", [], "any", false, false, true, 67) == "75_25")) {
            // line 68
            yield "    ";
            $context["first_class"] = "lg:w-9/12";
            // line 69
            yield "    ";
            $context["second_class"] = "lg:w-3/12";
        }
        // line 71
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_size", [], "any", false, false, true, 71), "value", [], "any", false, false, true, 71) == "66_33")) {
            // line 72
            yield "    ";
            $context["first_class"] = "lg:w-8/12";
            // line 73
            yield "    ";
            $context["second_class"] = "lg:w-4/12";
        }
        // line 75
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_size", [], "any", false, false, true, 75), "value", [], "any", false, false, true, 75) == "60_40")) {
            // line 76
            yield "    ";
            $context["first_class"] = "lg:w-7/12";
            // line 77
            yield "    ";
            $context["second_class"] = "lg:w-5/12";
        }
        // line 79
        yield "
";
        // line 80
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_vertical_align", [], "any", false, false, true, 80), "value", [], "any", false, false, true, 80) == "top")) {
            // line 81
            yield "    ";
            $context["verticle_align"] = "items-top";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source,         // line 82
($context["paragraph"] ?? null), "field_vertical_align", [], "any", false, false, true, 82), "value", [], "any", false, false, true, 82) == "bottom")) {
            // line 83
            yield "    ";
            $context["verticle_align"] = "items-bottom";
        } else {
            // line 85
            yield "    ";
            $context["verticle_align"] = "items-center";
        }
        // line 87
        yield "
";
        // line 88
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image_alt_text", [], "any", false, false, true, 88), "value", [], "any", false, false, true, 88))) {
            // line 89
            yield "  ";
            $context["alt_text"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image_alt_text", [], "any", false, false, true, 89), "value", [], "any", false, false, true, 89);
        } else {
            // line 91
            yield "  ";
            $context["alt_text"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 91), "entity", [], "any", false, false, true, 91), "field_media_image", [], "any", false, false, true, 91), "alt", [], "any", false, false, true, 91);
        }
        // line 93
        yield "
";
        // line 94
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_tags", [], "any", false, false, true, 94), "value", [], "any", false, false, true, 94))) {
            // line 95
            yield "    ";
            $context["title_heading"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_tags", [], "any", false, false, true, 95), "value", [], "any", false, false, true, 95);
        } else {
            // line 97
            yield "    ";
            $context["title_heading"] = "h5";
        }
        // line 99
        yield "
";
        // line 100
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_size_weight", [], "any", false, false, true, 100), "value", [], "any", false, false, true, 100))) {
            // line 101
            yield "    ";
            $context["heading_class"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_size_weight", [], "any", false, false, true, 101), "value", [], "any", false, false, true, 101);
        } else {
            // line 103
            yield "    ";
            $context["heading_class"] = "font-medium";
        }
        // line 105
        yield "

";
        // line 107
        yield from $this->unwrap()->yieldBlock('paragraph', $context, $blocks);
        // line 123
        yield " 
 
";
        $this->env->getExtension('\Drupal\Core\Template\TwigExtension')
            ->checkDeprecations($context, ["paragraph", "view_mode", "loop"]);        yield from [];
    }

    // line 107
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_paragraph(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 108
        yield "    ";
        yield from $this->unwrap()->yieldBlock('content', $context, $blocks);
        yield from [];
    }

    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 109
        yield "        <div data-node-id=\"";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "getParentEntity", [], "method", false, false, true, 109), "id", [], "method", false, false, true, 109), "html", null, true);
        yield "\" data-index=\"";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ((CoreExtension::getAttribute($this->env, $this->source, ($context["loop"] ?? null), "index", [], "any", true, true, true, 109)) ? (Twig\Extension\CoreExtension::default(CoreExtension::getAttribute($this->env, $this->source, ($context["loop"] ?? null), "index", [], "any", false, false, true, 109), "")) : ("")), "html", null, true);
        yield "\">
            ";
        // line 110
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title", [], "any", false, false, true, 110), "value", [], "any", false, false, true, 110))) {
            yield "<";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["title_heading"] ?? null), "html", null, true);
            yield " class=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["heading_class"] ?? null), "html", null, true);
            yield " pt-12.5\">";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title", [], "any", false, false, true, 110), "value", [], "any", false, false, true, 110));
            yield "</";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["title_heading"] ?? null), "html", null, true);
            yield ">";
        }
        // line 111
        yield "            <div class=\"flex flex-col md:flex-row gap-5 ";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["verticle_align"] ?? null), "html", null, true);
        yield " py-7 md:py-12.5\">
                <div class=\"w-full max-md:justify-center max-md:flex-col max-md:gap-5 ";
        // line 112
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["first_class"] ?? null), "html", null, true);
        yield " ";
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 112), "entity", [], "any", false, false, true, 112), "field_media_image", [], "any", false, false, true, 112), "entity", [], "any", false, false, true, 112), "uri", [], "any", false, false, true, 112), "value", [], "any", false, false, true, 112))) {
            yield "flex items-center gap-7.5";
        }
        yield "\">
                    ";
        // line 113
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 113), "entity", [], "any", false, false, true, 113), "field_media_image", [], "any", false, false, true, 113), "entity", [], "any", false, false, true, 113), "uri", [], "any", false, false, true, 113), "value", [], "any", false, false, true, 113))) {
            yield "<img src=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, $this->extensions['Drupal\Core\Template\TwigExtension']->getFileUrl(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 113), "entity", [], "any", false, false, true, 113), "field_media_image", [], "any", false, false, true, 113), "entity", [], "any", false, false, true, 113), "uri", [], "any", false, false, true, 113), "value", [], "any", false, false, true, 113)), "html", null, true);
            yield "\" class=\"size-25 md:size-50\" alt=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["alt_text"] ?? null), "html", null, true);
            yield "\">";
        }
        // line 114
        yield "                    ";
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_text", [], "any", false, false, true, 114), "value", [], "any", false, false, true, 114));
        yield "
                </div>
                <div class=\"w-full ";
        // line 116
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["second_class"] ?? null), "html", null, true);
        yield "\">
                    ";
        // line 117
        yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_text_2", [], "any", false, false, true, 117), "value", [], "any", false, false, true, 117));
        yield "
                </div>
            </div>
        </div>
    ";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "themes/custom/quitpath/templates/paragraph/paragraph--rows.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  260 => 117,  256 => 116,  250 => 114,  242 => 113,  234 => 112,  229 => 111,  217 => 110,  210 => 109,  198 => 108,  191 => 107,  183 => 123,  181 => 107,  177 => 105,  173 => 103,  169 => 101,  167 => 100,  164 => 99,  160 => 97,  156 => 95,  154 => 94,  151 => 93,  147 => 91,  143 => 89,  141 => 88,  138 => 87,  134 => 85,  130 => 83,  128 => 82,  125 => 81,  123 => 80,  120 => 79,  116 => 77,  113 => 76,  111 => 75,  107 => 73,  104 => 72,  102 => 71,  98 => 69,  95 => 68,  93 => 67,  89 => 65,  86 => 64,  84 => 63,  80 => 61,  77 => 60,  75 => 59,  71 => 57,  68 => 56,  66 => 55,  62 => 53,  59 => 52,  57 => 51,  54 => 50,  52 => 47,  51 => 46,  50 => 45,  49 => 43,  46 => 41,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{#
/**
 * @file
 * Default theme implementation to display a paragraph.
 *
 * Available variables:
 * - paragraph: Full paragraph entity.
 *   Only method names starting with \"get\", \"has\", or \"is\" and a few common
 *   methods such as \"id\", \"label\", and \"bundle\" are available. For example:
 *   - paragraph.getCreatedTime() will return the paragraph creation timestamp.
 *   - paragraph.id(): The paragraph ID.
 *   - paragraph.bundle(): The type of the paragraph, for example, \"image\" or \"text\".
 *   - paragraph.getOwnerId(): The user ID of the paragraph author.
 *   See Drupal\\paragraphs\\Entity\\Paragraph for a full list of public properties
 *   and methods for the paragraph object.
 * - content: All paragraph items. Use {{ content }} to print them all,
 *   or print a subset such as {{ content.field_example }}. Use
 *   {{ content|without('field_example') }} to temporarily suppress the printing
 *   of a given child element.
 * - attributes: HTML attributes for the containing element.
 *   The attributes.class element may contain one or more of the following
 *   classes:
 *   - paragraphs: The current template type (also known as a \"theming hook\").
 *   - paragraphs--type-[type]: The current paragraphs type. For example, if the paragraph is an
 *     \"Image\" it would result in \"paragraphs--type--image\". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - paragraphs--view-mode--[view_mode]: The View Mode of the paragraph; for example, a
 *     preview would result in: \"paragraphs--view-mode--preview\", and
 *     default: \"paragraphs--view-mode--default\".
 * - view_mode: View mode; for example, \"preview\" or \"full\".
 * - logged_in: Flag for authenticated user status. Will be true when the
 *   current user is a logged-in member.
 * - is_admin: Flag for admin user status. Will be true when the current user
 *   is an administrator.
 *
 * @see template_preprocess_paragraph()
 *
 * @ingroup themeable
 */
#}

{%
  set classes = [
    'paragraph',
    'paragraph--type--' ~ paragraph.bundle|clean_class,
    view_mode ? 'paragraph--view-mode--' ~ view_mode|clean_class,
    not paragraph.isPublished() ? 'paragraph--unpublished'
  ]
%}

{% if paragraph.field_size.value == '25_75' %}
    {%  set first_class = 'lg:w-3/12' %}
    {%  set second_class = 'lg:w-9/12' %}
{% endif %}
{% if paragraph.field_size.value == '33_66' %}
    {%  set first_class = 'lg:w-4/12' %}
    {%  set second_class = 'lg:w-8/12' %}
{% endif %}
{% if paragraph.field_size.value == '40_60' %}
    {%  set first_class = 'lg:w-5/12' %}
    {%  set second_class = 'lg:w-7/12' %}
{% endif %}
{% if paragraph.field_size.value == '50_50' %}
    {%  set first_class = 'lg:w-1/2' %}
    {%  set second_class = 'lg:w-1/2' %}
{% endif %}
{% if paragraph.field_size.value == '75_25' %}
    {%  set first_class = 'lg:w-9/12' %}
    {%  set second_class = 'lg:w-3/12' %}
{% endif %}
{% if paragraph.field_size.value == '66_33' %}
    {%  set first_class = 'lg:w-8/12' %}
    {%  set second_class = 'lg:w-4/12' %}
{% endif %}
{% if paragraph.field_size.value == '60_40' %}
    {%  set first_class = 'lg:w-7/12' %}
    {%  set second_class = 'lg:w-5/12' %}
{% endif %}

{% if paragraph.field_vertical_align.value == 'top' %}
    {%  set verticle_align = 'items-top' %}
{% elseif paragraph.field_vertical_align.value == 'bottom' %}
    {%  set verticle_align = 'items-bottom' %}
{% else %}
    {%  set verticle_align = 'items-center' %}
{% endif %}

{% if paragraph.field_image_alt_text.value is not empty %}
  {% set alt_text =  paragraph.field_image_alt_text.value  %}
{% else %}
  {% set alt_text =  paragraph.field_image.entity.field_media_image.alt  %}
{% endif %}

{% if paragraph.field_title_tags.value is not empty %}
    {% set title_heading =  paragraph.field_title_tags.value  %}
{% else %}
    {% set title_heading =  'h5'  %}
{% endif %}

{% if paragraph.field_title_size_weight.value is not empty %}
    {% set heading_class =  paragraph.field_title_size_weight.value  %}
{% else %}
    {% set heading_class =  'font-medium'  %}
{% endif %}


{% block paragraph %}
    {% block content %}
        <div data-node-id=\"{{ paragraph.getParentEntity().id() }}\" data-index=\"{{ loop.index|default('') }}\">
            {% if paragraph.field_title.value is not empty %}<{{ title_heading }} class=\"{{ heading_class }} pt-12.5\">{{  paragraph.field_title.value|raw }}</{{ title_heading }}>{% endif %}
            <div class=\"flex flex-col md:flex-row gap-5 {{ verticle_align }} py-7 md:py-12.5\">
                <div class=\"w-full max-md:justify-center max-md:flex-col max-md:gap-5 {{ first_class }} {% if paragraph.field_image.entity.field_media_image.entity.uri.value is not empty %}flex items-center gap-7.5{% endif %}\">
                    {% if paragraph.field_image.entity.field_media_image.entity.uri.value is not empty %}<img src=\"{{ file_url(paragraph.field_image.entity.field_media_image.entity.uri.value) }}\" class=\"size-25 md:size-50\" alt=\"{{ alt_text }}\">{% endif %}
                    {{ paragraph.field_text.value|raw }}
                </div>
                <div class=\"w-full {{ second_class }}\">
                    {{ paragraph.field_text_2.value|raw }}
                </div>
            </div>
        </div>
    {% endblock %}
{% endblock paragraph %}
 
 
", "themes/custom/quitpath/templates/paragraph/paragraph--rows.html.twig", "/home/quitpathshareaco/public_html/web/themes/custom/quitpath/templates/paragraph/paragraph--rows.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["set" => 43, "if" => 51, "block" => 107];
        static $filters = ["clean_class" => 45, "escape" => 109, "default" => 109, "raw" => 110];
        static $functions = ["file_url" => 113];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'if', 'block'],
                ['clean_class', 'escape', 'default', 'raw'],
                ['file_url'],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
