<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* themes/custom/quitpath/templates/paragraph/paragraph--story.html.twig */
class __TwigTemplate_f000f6b450f721f35f65ecd54d4539f7 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'paragraph' => [$this, 'block_paragraph'],
            'content' => [$this, 'block_content'],
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 42
        $context["classes"] = ["paragraph", ("paragraph--type--" . \Drupal\Component\Utility\Html::getClass(CoreExtension::getAttribute($this->env, $this->source,         // line 44
($context["paragraph"] ?? null), "bundle", [], "any", false, false, true, 44))), ((        // line 45
($context["view_mode"] ?? null)) ? (("paragraph--view-mode--" . \Drupal\Component\Utility\Html::getClass(($context["view_mode"] ?? null)))) : ("")), (( !CoreExtension::getAttribute($this->env, $this->source,         // line 46
($context["paragraph"] ?? null), "isPublished", [], "method", false, false, true, 46)) ? ("paragraph--unpublished") : (""))];
        // line 49
        yield "
";
        // line 50
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_tags", [], "any", false, false, true, 50), "value", [], "any", false, false, true, 50))) {
            // line 51
            yield "    ";
            $context["title_heading"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_tags", [], "any", false, false, true, 51), "value", [], "any", false, false, true, 51);
        } else {
            // line 53
            yield "    ";
            $context["title_heading"] = "h2";
        }
        // line 55
        yield "
";
        // line 56
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_size_weight", [], "any", false, false, true, 56), "value", [], "any", false, false, true, 56))) {
            // line 57
            yield "    ";
            $context["heading_class"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title_size_weight", [], "any", false, false, true, 57), "value", [], "any", false, false, true, 57);
        } else {
            // line 59
            yield "    ";
            $context["heading_class"] = "font-medium";
        }
        // line 61
        yield "

";
        // line 63
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image_alt_text", [], "any", false, false, true, 63), "value", [], "any", false, false, true, 63))) {
            // line 64
            yield "  ";
            $context["alt_text"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image_alt_text", [], "any", false, false, true, 64), "value", [], "any", false, false, true, 64);
        } else {
            // line 66
            yield "  ";
            $context["alt_text"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 66), "entity", [], "any", false, false, true, 66), "field_media_image", [], "any", false, false, true, 66), "alt", [], "any", false, false, true, 66);
        }
        // line 68
        yield from $this->unwrap()->yieldBlock('paragraph', $context, $blocks);
        // line 109
        yield " 
 
";
        $this->env->getExtension('\Drupal\Core\Template\TwigExtension')
            ->checkDeprecations($context, ["paragraph", "view_mode"]);        yield from [];
    }

    // line 68
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_paragraph(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 69
        yield "    ";
        yield from $this->unwrap()->yieldBlock('content', $context, $blocks);
        yield from [];
    }

    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 70
        yield "        <div class=\"container mx-auto space-y-15 pt-25\">
            ";
        // line 71
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_position", [], "any", false, false, true, 71), "value", [], "any", false, false, true, 71) == "right")) {
            // line 72
            yield "                <div class=\"flex flex-col lg:flex-row gap-5\">
                    <div class=\"w-full lg:w-5/12\">
                        ";
            // line 74
            if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 74), "entity", [], "any", false, false, true, 74), "field_media_image", [], "any", false, false, true, 74), "entity", [], "any", false, false, true, 74), "uri", [], "any", false, false, true, 74), "value", [], "any", false, false, true, 74))) {
                yield "<img src=\"";
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, $this->extensions['Drupal\Core\Template\TwigExtension']->getFileUrl(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 74), "entity", [], "any", false, false, true, 74), "field_media_image", [], "any", false, false, true, 74), "entity", [], "any", false, false, true, 74), "uri", [], "any", false, false, true, 74), "value", [], "any", false, false, true, 74)), "html", null, true);
                yield "\" class=\"w-[fill-available] md:-mr-[100px] xl:-mr-[130px] max-h-200\" alt=\"";
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["alt_text"] ?? null), "html", null, true);
                yield "\">";
            }
            // line 75
            yield "                    </div>
                    <div class=\"w-full lg:w-7/12 space-y-2.5 lg:space-y-7.5\">
                        <";
            // line 77
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["title_heading"] ?? null), "html", null, true);
            yield " class=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["heading_class"] ?? null), "html", null, true);
            yield "\">";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title", [], "any", false, false, true, 77), "value", [], "any", false, false, true, 77));
            yield "</";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["title_heading"] ?? null), "html", null, true);
            yield ">
                        <div class=\"text-display-xs\">
                            <p class=\"s24-w400\"><b>";
            // line 79
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Age"));
            yield ":</b>&nbsp;";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_age", [], "any", false, false, true, 79), "value", [], "any", false, false, true, 79));
            yield "</p>
                            <p class=\"s24-w400\"><b>";
            // line 80
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Product"));
            yield ":</b>&nbsp;";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_product", [], "any", false, false, true, 80), "value", [], "any", false, false, true, 80));
            yield "</p>
                            <p class=\"s24-w400\"><b>";
            // line 81
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Years using"));
            yield ":</b>&nbsp;";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_years_using", [], "any", false, false, true, 81), "value", [], "any", false, false, true, 81));
            yield "</p>
                            <p class=\"s24-w400\"><b>";
            // line 82
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Quit date"));
            yield ":</b>&nbsp;";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_quit_date", [], "any", false, false, true, 82), "value", [], "any", false, false, true, 82));
            yield "</p>
                        </div>
                        ";
            // line 84
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_story", [], "any", false, false, true, 84), "value", [], "any", false, false, true, 84));
            yield "    
                    </div>
                </div>
            ";
        } else {
            // line 88
            yield "                <div class=\"flex flex-col lg:flex-row gap-5\">
                    <div class=\"w-full lg:w-7/12 space-y-2.5 lg:space-y-7.5\">
                        <";
            // line 90
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["title_heading"] ?? null), "html", null, true);
            yield " class=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["heading_class"] ?? null), "html", null, true);
            yield "\">";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title", [], "any", false, false, true, 90), "value", [], "any", false, false, true, 90));
            yield "</";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["title_heading"] ?? null), "html", null, true);
            yield ">
                        <div class=\"text-display-xs\">
                            <p class=\"s24-w400\"><b>";
            // line 92
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Age"));
            yield ":</b>&nbsp;";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_age", [], "any", false, false, true, 92), "value", [], "any", false, false, true, 92));
            yield "</p>
                            <p class=\"s24-w400\"><b>";
            // line 93
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Product"));
            yield ":</b>&nbsp;";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_product", [], "any", false, false, true, 93), "value", [], "any", false, false, true, 93));
            yield "</p>
                            <p class=\"s24-w400\"><b>";
            // line 94
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Years using"));
            yield ":</b>&nbsp;";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_years_using", [], "any", false, false, true, 94), "value", [], "any", false, false, true, 94));
            yield "</p>
                            <p class=\"s24-w400\"><b>";
            // line 95
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(t("Quit date"));
            yield ":</b>&nbsp;";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_quit_date", [], "any", false, false, true, 95), "value", [], "any", false, false, true, 95));
            yield "</p>
                        </div>
                        ";
            // line 97
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_story", [], "any", false, false, true, 97), "value", [], "any", false, false, true, 97));
            yield "
                    </div>
                    <div class=\"w-full lg:w-5/12\">
                        ";
            // line 100
            if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 100), "entity", [], "any", false, false, true, 100), "field_media_image", [], "any", false, false, true, 100), "entity", [], "any", false, false, true, 100), "uri", [], "any", false, false, true, 100), "value", [], "any", false, false, true, 100))) {
                yield "<img src=\"";
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, $this->extensions['Drupal\Core\Template\TwigExtension']->getFileUrl(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 100), "entity", [], "any", false, false, true, 100), "field_media_image", [], "any", false, false, true, 100), "entity", [], "any", false, false, true, 100), "uri", [], "any", false, false, true, 100), "value", [], "any", false, false, true, 100)), "html", null, true);
                yield "\" class=\"w-[fill-available] md:-mr-[100px] xl:-mr-[130px] max-h-200\" alt=\"";
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["alt_text"] ?? null), "html", null, true);
                yield "\">";
            }
            // line 101
            yield "                    </div>
                </div>
            ";
        }
        // line 104
        yield "            
        </div>

    ";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "themes/custom/quitpath/templates/paragraph/paragraph--story.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  243 => 104,  238 => 101,  230 => 100,  224 => 97,  217 => 95,  211 => 94,  205 => 93,  199 => 92,  188 => 90,  184 => 88,  177 => 84,  170 => 82,  164 => 81,  158 => 80,  152 => 79,  141 => 77,  137 => 75,  129 => 74,  125 => 72,  123 => 71,  120 => 70,  108 => 69,  101 => 68,  93 => 109,  91 => 68,  87 => 66,  83 => 64,  81 => 63,  77 => 61,  73 => 59,  69 => 57,  67 => 56,  64 => 55,  60 => 53,  56 => 51,  54 => 50,  51 => 49,  49 => 46,  48 => 45,  47 => 44,  46 => 42,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{#
/**
 * @file
 * Default theme implementation to display a paragraph.
 *
 * Available variables:
 * - paragraph: Full paragraph entity.
 *   Only method names starting with \"get\", \"has\", or \"is\" and a few common
 *   methods such as \"id\", \"label\", and \"bundle\" are available. For example:
 *   - paragraph.getCreatedTime() will return the paragraph creation timestamp.
 *   - paragraph.id(): The paragraph ID.
 *   - paragraph.bundle(): The type of the paragraph, for example, \"image\" or \"text\".
 *   - paragraph.getOwnerId(): The user ID of the paragraph author.
 *   See Drupal\\paragraphs\\Entity\\Paragraph for a full list of public properties
 *   and methods for the paragraph object.
 * - content: All paragraph items. Use {{ content }} to print them all,
 *   or print a subset such as {{ content.field_example }}. Use
 *   {{ content|without('field_example') }} to temporarily suppress the printing
 *   of a given child element.
 * - attributes: HTML attributes for the containing element.
 *   The attributes.class element may contain one or more of the following
 *   classes:
 *   - paragraphs: The current template type (also known as a \"theming hook\").
 *   - paragraphs--type-[type]: The current paragraphs type. For example, if the paragraph is an
 *     \"Image\" it would result in \"paragraphs--type--image\". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - paragraphs--view-mode--[view_mode]: The View Mode of the paragraph; for example, a
 *     preview would result in: \"paragraphs--view-mode--preview\", and
 *     default: \"paragraphs--view-mode--default\".
 * - view_mode: View mode; for example, \"preview\" or \"full\".
 * - logged_in: Flag for authenticated user status. Will be true when the
 *   current user is a logged-in member.
 * - is_admin: Flag for admin user status. Will be true when the current user
 *   is an administrator.
 *
 * @see template_preprocess_paragraph()
 *
 * @ingroup themeable
 */
#}
{%
  set classes = [
    'paragraph',
    'paragraph--type--' ~ paragraph.bundle|clean_class,
    view_mode ? 'paragraph--view-mode--' ~ view_mode|clean_class,
    not paragraph.isPublished() ? 'paragraph--unpublished'
  ]
%}

{% if paragraph.field_title_tags.value is not empty %}
    {% set title_heading =  paragraph.field_title_tags.value  %}
{% else %}
    {% set title_heading =  'h2'  %}
{% endif %}

{% if paragraph.field_title_size_weight.value is not empty %}
    {% set heading_class =  paragraph.field_title_size_weight.value  %}
{% else %}
    {% set heading_class =  'font-medium'  %}
{% endif %}


{% if paragraph.field_image_alt_text.value is not empty %}
  {% set alt_text =  paragraph.field_image_alt_text.value  %}
{% else %}
  {% set alt_text =  paragraph.field_image.entity.field_media_image.alt  %}
{% endif %}
{% block paragraph %}
    {% block content %}
        <div class=\"container mx-auto space-y-15 pt-25\">
            {% if paragraph.field_position.value == \"right\" %}
                <div class=\"flex flex-col lg:flex-row gap-5\">
                    <div class=\"w-full lg:w-5/12\">
                        {% if paragraph.field_image.entity.field_media_image.entity.uri.value is not empty %}<img src=\"{{ file_url(paragraph.field_image.entity.field_media_image.entity.uri.value) }}\" class=\"w-[fill-available] md:-mr-[100px] xl:-mr-[130px] max-h-200\" alt=\"{{ alt_text }}\">{% endif %}
                    </div>
                    <div class=\"w-full lg:w-7/12 space-y-2.5 lg:space-y-7.5\">
                        <{{ title_heading }} class=\"{{ heading_class }}\">{{ paragraph.field_title.value|raw }}</{{ title_heading }}>
                        <div class=\"text-display-xs\">
                            <p class=\"s24-w400\"><b>{{ 'Age'|t }}:</b>&nbsp;{{ paragraph.field_age.value|raw }}</p>
                            <p class=\"s24-w400\"><b>{{ 'Product'|t }}:</b>&nbsp;{{ paragraph.field_product.value|raw }}</p>
                            <p class=\"s24-w400\"><b>{{ 'Years using'|t }}:</b>&nbsp;{{ paragraph.field_years_using.value|raw }}</p>
                            <p class=\"s24-w400\"><b>{{ 'Quit date'|t }}:</b>&nbsp;{{ paragraph.field_quit_date.value|raw }}</p>
                        </div>
                        {{ paragraph.field_story.value|raw }}    
                    </div>
                </div>
            {% else %}
                <div class=\"flex flex-col lg:flex-row gap-5\">
                    <div class=\"w-full lg:w-7/12 space-y-2.5 lg:space-y-7.5\">
                        <{{ title_heading }} class=\"{{ heading_class }}\">{{ paragraph.field_title.value|raw }}</{{ title_heading }}>
                        <div class=\"text-display-xs\">
                            <p class=\"s24-w400\"><b>{{ 'Age'|t }}:</b>&nbsp;{{ paragraph.field_age.value|raw }}</p>
                            <p class=\"s24-w400\"><b>{{ 'Product'|t }}:</b>&nbsp;{{ paragraph.field_product.value|raw }}</p>
                            <p class=\"s24-w400\"><b>{{ 'Years using'|t }}:</b>&nbsp;{{ paragraph.field_years_using.value|raw }}</p>
                            <p class=\"s24-w400\"><b>{{ 'Quit date'|t }}:</b>&nbsp;{{ paragraph.field_quit_date.value|raw }}</p>
                        </div>
                        {{ paragraph.field_story.value|raw }}
                    </div>
                    <div class=\"w-full lg:w-5/12\">
                        {% if paragraph.field_image.entity.field_media_image.entity.uri.value is not empty %}<img src=\"{{ file_url(paragraph.field_image.entity.field_media_image.entity.uri.value) }}\" class=\"w-[fill-available] md:-mr-[100px] xl:-mr-[130px] max-h-200\" alt=\"{{ alt_text }}\">{% endif %}
                    </div>
                </div>
            {% endif %}
            
        </div>

    {% endblock %}
{% endblock paragraph %}
 
 
", "themes/custom/quitpath/templates/paragraph/paragraph--story.html.twig", "/home/quitpathshareaco/public_html/web/themes/custom/quitpath/templates/paragraph/paragraph--story.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["set" => 42, "if" => 50, "block" => 68];
        static $filters = ["clean_class" => 44, "escape" => 74, "raw" => 77, "t" => 79];
        static $functions = ["file_url" => 74];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'if', 'block'],
                ['clean_class', 'escape', 'raw', 't'],
                ['file_url'],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
