<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* themes/custom/quitpath/templates/paragraph/paragraph--previous-next-button.html.twig */
class __TwigTemplate_4228b7661ef5866cb8a17a0c9c506ba8 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'paragraph' => [$this, 'block_paragraph'],
            'content' => [$this, 'block_content'],
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 41
        yield "
";
        // line 43
        $context["classes"] = ["paragraph", ("paragraph--type--" . \Drupal\Component\Utility\Html::getClass(CoreExtension::getAttribute($this->env, $this->source,         // line 45
($context["paragraph"] ?? null), "bundle", [], "any", false, false, true, 45))), ((        // line 46
($context["view_mode"] ?? null)) ? (("paragraph--view-mode--" . \Drupal\Component\Utility\Html::getClass(($context["view_mode"] ?? null)))) : ("")), (( !CoreExtension::getAttribute($this->env, $this->source,         // line 47
($context["paragraph"] ?? null), "isPublished", [], "method", false, false, true, 47)) ? ("paragraph--unpublished") : (""))];
        // line 50
        yield "
";
        // line 51
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_button_color", [], "any", false, false, true, 51), "value", [], "any", false, false, true, 51) == "yellow")) {
            // line 52
            yield "    ";
            $context["color"] = "bg-yellow-400 px-4.5 py-2.5 border border-yellow-600 rounded-lg font-semibold text-md text-white";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source,         // line 53
($context["paragraph"] ?? null), "field_button_color", [], "any", false, false, true, 53), "value", [], "any", false, false, true, 53) == "blue")) {
            // line 54
            yield "    ";
            $context["color"] = "bg-light-blue-400 px-4.5 py-2.5 border border-light-blue-600 rounded-lg font-semibold text-md text-white";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source,         // line 55
($context["paragraph"] ?? null), "field_button_color", [], "any", false, false, true, 55), "value", [], "any", false, false, true, 55) == "red")) {
            // line 56
            yield "    ";
            $context["color"] = "bg-red-400 px-4.5 py-2.5 border border-red-600 rounded-lg font-semibold text-md text-white";
        } elseif ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source,         // line 57
($context["paragraph"] ?? null), "field_button_color", [], "any", false, false, true, 57), "value", [], "any", false, false, true, 57) == "green")) {
            // line 58
            yield "    ";
            $context["color"] = "bg-green-400 px-4.5 py-2.5 border border-green-600 rounded-lg font-semibold text-md text-white";
        }
        // line 60
        yield "
";
        // line 61
        yield from $this->unwrap()->yieldBlock('paragraph', $context, $blocks);
        // line 84
        yield " 
 

";
        $this->env->getExtension('\Drupal\Core\Template\TwigExtension')
            ->checkDeprecations($context, ["paragraph", "view_mode"]);        yield from [];
    }

    // line 61
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_paragraph(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 62
        yield "    ";
        yield from $this->unwrap()->yieldBlock('content', $context, $blocks);
        yield from [];
    }

    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 63
        yield "            <div class=\"pt-25\">
                ";
        // line 64
        if (( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_previous", [], "any", false, false, true, 64), "title", [], "any", false, false, true, 64)) &&  !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_next", [], "any", false, false, true, 64), "title", [], "any", false, false, true, 64)))) {
            // line 65
            yield "                    <div class=\"mx-auto container flex gap-7.5\">
                        <a href=\"";
            // line 66
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_previous", [], "any", false, false, true, 66), "get", [0], "method", false, false, true, 66), "getUrl", [], "method", false, false, true, 66), "toString", [], "method", false, false, true, 66), "html", null, true);
            yield "\" class=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["color"] ?? null), "html", null, true);
            yield "\">";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_previous", [], "any", false, false, true, 66), "title", [], "any", false, false, true, 66), "html", null, true);
            yield "</a>
                        <a href=\"";
            // line 67
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_next", [], "any", false, false, true, 67), "get", [0], "method", false, false, true, 67), "getUrl", [], "method", false, false, true, 67), "toString", [], "method", false, false, true, 67), "html", null, true);
            yield "\" class=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["color"] ?? null), "html", null, true);
            yield "\">";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_next", [], "any", false, false, true, 67), "title", [], "any", false, false, true, 67), "html", null, true);
            yield "</a>
                    </div>
                ";
        } else {
            // line 70
            yield "                    <div class=\"mx-auto container\">
                        ";
            // line 71
            if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_previous", [], "any", false, false, true, 71), "title", [], "any", false, false, true, 71))) {
                // line 72
                yield "                            <a href=\"";
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_previous", [], "any", false, false, true, 72), "get", [0], "method", false, false, true, 72), "getUrl", [], "method", false, false, true, 72), "toString", [], "method", false, false, true, 72), "html", null, true);
                yield "\" class=\"";
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["color"] ?? null), "html", null, true);
                yield "\">";
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_previous", [], "any", false, false, true, 72), "title", [], "any", false, false, true, 72), "html", null, true);
                yield "</a>
                        ";
            }
            // line 74
            yield "                        ";
            if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_next", [], "any", false, false, true, 74), "title", [], "any", false, false, true, 74))) {
                // line 75
                yield "                            <a href=\"";
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_next", [], "any", false, false, true, 75), "get", [0], "method", false, false, true, 75), "getUrl", [], "method", false, false, true, 75), "toString", [], "method", false, false, true, 75), "html", null, true);
                yield "\" class=\"";
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["color"] ?? null), "html", null, true);
                yield "\">";
                yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_next", [], "any", false, false, true, 75), "title", [], "any", false, false, true, 75), "html", null, true);
                yield "</a>
                        ";
            }
            // line 77
            yield "                    </div>
                
                ";
        }
        // line 80
        yield "            </div>

    ";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "themes/custom/quitpath/templates/paragraph/paragraph--previous-next-button.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  170 => 80,  165 => 77,  155 => 75,  152 => 74,  142 => 72,  140 => 71,  137 => 70,  127 => 67,  119 => 66,  116 => 65,  114 => 64,  111 => 63,  99 => 62,  92 => 61,  83 => 84,  81 => 61,  78 => 60,  74 => 58,  72 => 57,  69 => 56,  67 => 55,  64 => 54,  62 => 53,  59 => 52,  57 => 51,  54 => 50,  52 => 47,  51 => 46,  50 => 45,  49 => 43,  46 => 41,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{#
/**
 * @file
 * Default theme implementation to display a paragraph.
 *
 * Available variables:
 * - paragraph: Full paragraph entity.
 *   Only method names starting with \"get\", \"has\", or \"is\" and a few common
 *   methods such as \"id\", \"label\", and \"bundle\" are available. For example:
 *   - paragraph.getCreatedTime() will return the paragraph creation timestamp.
 *   - paragraph.id(): The paragraph ID.
 *   - paragraph.bundle(): The type of the paragraph, for example, \"image\" or \"text\".
 *   - paragraph.getOwnerId(): The user ID of the paragraph author.
 *   See Drupal\\paragraphs\\Entity\\Paragraph for a full list of public properties
 *   and methods for the paragraph object.
 * - content: All paragraph items. Use {{ content }} to print them all,
 *   or print a subset such as {{ content.field_example }}. Use
 *   {{ content|without('field_example') }} to temporarily suppress the printing
 *   of a given child element.
 * - attributes: HTML attributes for the containing element.
 *   The attributes.class element may contain one or more of the following
 *   classes:
 *   - paragraphs: The current template type (also known as a \"theming hook\").
 *   - paragraphs--type-[type]: The current paragraphs type. For example, if the paragraph is an
 *     \"Image\" it would result in \"paragraphs--type--image\". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - paragraphs--view-mode--[view_mode]: The View Mode of the paragraph; for example, a
 *     preview would result in: \"paragraphs--view-mode--preview\", and
 *     default: \"paragraphs--view-mode--default\".
 * - view_mode: View mode; for example, \"preview\" or \"full\".
 * - logged_in: Flag for authenticated user status. Will be true when the
 *   current user is a logged-in member.
 * - is_admin: Flag for admin user status. Will be true when the current user
 *   is an administrator.
 *
 * @see template_preprocess_paragraph()
 *
 * @ingroup themeable
 */
#}

{%
  set classes = [
    'paragraph',
    'paragraph--type--' ~ paragraph.bundle|clean_class,
    view_mode ? 'paragraph--view-mode--' ~ view_mode|clean_class,
    not paragraph.isPublished() ? 'paragraph--unpublished'
  ]
%}

{% if paragraph.field_button_color.value == 'yellow' %}
    {%  set color = 'bg-yellow-400 px-4.5 py-2.5 border border-yellow-600 rounded-lg font-semibold text-md text-white' %}
{% elseif paragraph.field_button_color.value == 'blue' %}
    {%  set color = 'bg-light-blue-400 px-4.5 py-2.5 border border-light-blue-600 rounded-lg font-semibold text-md text-white' %}
{% elseif paragraph.field_button_color.value == 'red' %}
    {%  set color = 'bg-red-400 px-4.5 py-2.5 border border-red-600 rounded-lg font-semibold text-md text-white' %}
{% elseif paragraph.field_button_color.value == 'green' %}
    {%  set color = 'bg-green-400 px-4.5 py-2.5 border border-green-600 rounded-lg font-semibold text-md text-white' %}
{% endif %}

{% block paragraph %}
    {% block content %}
            <div class=\"pt-25\">
                {% if paragraph.field_previous.title is not empty and paragraph.field_next.title is not empty %}
                    <div class=\"mx-auto container flex gap-7.5\">
                        <a href=\"{{ paragraph.field_previous.get(0).getUrl().toString() }}\" class=\"{{ color }}\">{{ paragraph.field_previous.title }}</a>
                        <a href=\"{{ paragraph.field_next.get(0).getUrl().toString() }}\" class=\"{{ color }}\">{{ paragraph.field_next.title }}</a>
                    </div>
                {% else %}
                    <div class=\"mx-auto container\">
                        {% if paragraph.field_previous.title is not empty %}
                            <a href=\"{{ paragraph.field_previous.get(0).getUrl().toString() }}\" class=\"{{ color }}\">{{ paragraph.field_previous.title }}</a>
                        {% endif %}
                        {% if paragraph.field_next.title is not empty %}
                            <a href=\"{{ paragraph.field_next.get(0).getUrl().toString() }}\" class=\"{{ color }}\">{{ paragraph.field_next.title }}</a>
                        {% endif %}
                    </div>
                
                {% endif %}
            </div>

    {% endblock %}
{% endblock paragraph %}
 
 

", "themes/custom/quitpath/templates/paragraph/paragraph--previous-next-button.html.twig", "/home/quitpathshareaco/public_html/web/themes/custom/quitpath/templates/paragraph/paragraph--previous-next-button.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["set" => 43, "if" => 51, "block" => 61];
        static $filters = ["clean_class" => 45, "escape" => 66];
        static $functions = [];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'if', 'block'],
                ['clean_class', 'escape'],
                [],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
