<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* themes/custom/quitpath/templates/paragraph/paragraph--story.html.twig */
class __TwigTemplate_f000f6b450f721f35f65ecd54d4539f7 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'paragraph' => [$this, 'block_paragraph'],
            'content' => [$this, 'block_content'],
        ];
        $this->sandbox = $this->extensions[SandboxExtension::class];
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 42
        $context["classes"] = ["paragraph", ("paragraph--type--" . \Drupal\Component\Utility\Html::getClass(CoreExtension::getAttribute($this->env, $this->source,         // line 44
($context["paragraph"] ?? null), "bundle", [], "any", false, false, true, 44))), ((        // line 45
($context["view_mode"] ?? null)) ? (("paragraph--view-mode--" . \Drupal\Component\Utility\Html::getClass(($context["view_mode"] ?? null)))) : ("")), (( !CoreExtension::getAttribute($this->env, $this->source,         // line 46
($context["paragraph"] ?? null), "isPublished", [], "method", false, false, true, 46)) ? ("paragraph--unpublished") : (""))];
        // line 49
        if ( !Twig\Extension\CoreExtension::testEmpty(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image_alt_text", [], "any", false, false, true, 49), "value", [], "any", false, false, true, 49))) {
            // line 50
            yield "  ";
            $context["alt_text"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image_alt_text", [], "any", false, false, true, 50), "value", [], "any", false, false, true, 50);
        } else {
            // line 52
            yield "  ";
            $context["alt_text"] = CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 52), "entity", [], "any", false, false, true, 52), "field_media_image", [], "any", false, false, true, 52), "alt", [], "any", false, false, true, 52);
        }
        // line 54
        yield from $this->unwrap()->yieldBlock('paragraph', $context, $blocks);
        // line 95
        yield " 
 
";
        $this->env->getExtension('\Drupal\Core\Template\TwigExtension')
            ->checkDeprecations($context, ["paragraph", "view_mode"]);        yield from [];
    }

    // line 54
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_paragraph(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 55
        yield "    ";
        yield from $this->unwrap()->yieldBlock('content', $context, $blocks);
        yield from [];
    }

    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 56
        yield "        <div class=\"container mx-auto space-y-15 pt-25\">
            ";
        // line 57
        if ((CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_position", [], "any", false, false, true, 57), "value", [], "any", false, false, true, 57) == "right")) {
            // line 58
            yield "                <div class=\"flex flex-col lg:flex-row gap-5\">
                    <div class=\"w-full lg:w-5/12\">
                        <img src=\"";
            // line 60
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, $this->extensions['Drupal\Core\Template\TwigExtension']->getFileUrl(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 60), "entity", [], "any", false, false, true, 60), "field_media_image", [], "any", false, false, true, 60), "entity", [], "any", false, false, true, 60), "uri", [], "any", false, false, true, 60), "value", [], "any", false, false, true, 60)), "html", null, true);
            yield "\" class=\"w-[fill-available] md:-mr-[100px] xl:-mr-[130px] max-h-200\" alt=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["alt_text"] ?? null), "html", null, true);
            yield "\">
                    </div>
                    <div class=\"w-full lg:w-7/12 space-y-2.5 lg:space-y-7.5\">
                        <h2 class=\"font-medium\">";
            // line 63
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title", [], "any", false, false, true, 63), "value", [], "any", false, false, true, 63));
            yield "</h2>
                        <div class=\"text-display-xs\">
                            <h6><b>Age:</b>&nbsp;";
            // line 65
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_age", [], "any", false, false, true, 65), "value", [], "any", false, false, true, 65));
            yield "</h6>
                            <h6><b>Product:</b>&nbsp;";
            // line 66
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_product", [], "any", false, false, true, 66), "value", [], "any", false, false, true, 66));
            yield "</h6>
                            <h6><b>Years using:</b>&nbsp;";
            // line 67
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_years_using", [], "any", false, false, true, 67), "value", [], "any", false, false, true, 67));
            yield "</h6>
                            <h6><b>Quit date:</b>&nbsp;";
            // line 68
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_quit_date", [], "any", false, false, true, 68), "value", [], "any", false, false, true, 68));
            yield "</h6>
                        </div>
                        ";
            // line 70
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_story", [], "any", false, false, true, 70), "value", [], "any", false, false, true, 70));
            yield "    
                    </div>
                </div>
            ";
        } else {
            // line 74
            yield "                <div class=\"flex flex-col lg:flex-row gap-5\">
                    <div class=\"w-full lg:w-7/12 space-y-2.5 lg:space-y-7.5\">
                        <h2 class=\"font-medium\">";
            // line 76
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_title", [], "any", false, false, true, 76), "value", [], "any", false, false, true, 76));
            yield "</h2>
                        <div class=\"text-display-xs\">
                            <h6><b>Age:</b>&nbsp;";
            // line 78
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_age", [], "any", false, false, true, 78), "value", [], "any", false, false, true, 78));
            yield "</h6>
                            <h6><b>Product:</b>&nbsp;";
            // line 79
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_product", [], "any", false, false, true, 79), "value", [], "any", false, false, true, 79));
            yield "</h6>
                            <h6><b>Years using:</b>&nbsp;";
            // line 80
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_years_using", [], "any", false, false, true, 80), "value", [], "any", false, false, true, 80));
            yield "</h6>
                            <h6><b>Quit date:</b>&nbsp;";
            // line 81
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_quit_date", [], "any", false, false, true, 81), "value", [], "any", false, false, true, 81));
            yield "</h6>
                        </div>
                        ";
            // line 83
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->renderVar(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_story", [], "any", false, false, true, 83), "value", [], "any", false, false, true, 83));
            yield "
                    </div>
                    <div class=\"w-full lg:w-5/12\">
                        <img src=\"";
            // line 86
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, $this->extensions['Drupal\Core\Template\TwigExtension']->getFileUrl(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, ($context["paragraph"] ?? null), "field_image", [], "any", false, false, true, 86), "entity", [], "any", false, false, true, 86), "field_media_image", [], "any", false, false, true, 86), "entity", [], "any", false, false, true, 86), "uri", [], "any", false, false, true, 86), "value", [], "any", false, false, true, 86)), "html", null, true);
            yield "\" class=\"w-[fill-available] md:-mr-[100px] xl:-mr-[130px] max-h-200\" alt=\"";
            yield $this->extensions['Drupal\Core\Template\TwigExtension']->escapeFilter($this->env, ($context["alt_text"] ?? null), "html", null, true);
            yield "\">
                    </div>
                </div>
            ";
        }
        // line 90
        yield "            
        </div>

    ";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "themes/custom/quitpath/templates/paragraph/paragraph--story.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  177 => 90,  168 => 86,  162 => 83,  157 => 81,  153 => 80,  149 => 79,  145 => 78,  140 => 76,  136 => 74,  129 => 70,  124 => 68,  120 => 67,  116 => 66,  112 => 65,  107 => 63,  99 => 60,  95 => 58,  93 => 57,  90 => 56,  78 => 55,  71 => 54,  63 => 95,  61 => 54,  57 => 52,  53 => 50,  51 => 49,  49 => 46,  48 => 45,  47 => 44,  46 => 42,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{#
/**
 * @file
 * Default theme implementation to display a paragraph.
 *
 * Available variables:
 * - paragraph: Full paragraph entity.
 *   Only method names starting with \"get\", \"has\", or \"is\" and a few common
 *   methods such as \"id\", \"label\", and \"bundle\" are available. For example:
 *   - paragraph.getCreatedTime() will return the paragraph creation timestamp.
 *   - paragraph.id(): The paragraph ID.
 *   - paragraph.bundle(): The type of the paragraph, for example, \"image\" or \"text\".
 *   - paragraph.getOwnerId(): The user ID of the paragraph author.
 *   See Drupal\\paragraphs\\Entity\\Paragraph for a full list of public properties
 *   and methods for the paragraph object.
 * - content: All paragraph items. Use {{ content }} to print them all,
 *   or print a subset such as {{ content.field_example }}. Use
 *   {{ content|without('field_example') }} to temporarily suppress the printing
 *   of a given child element.
 * - attributes: HTML attributes for the containing element.
 *   The attributes.class element may contain one or more of the following
 *   classes:
 *   - paragraphs: The current template type (also known as a \"theming hook\").
 *   - paragraphs--type-[type]: The current paragraphs type. For example, if the paragraph is an
 *     \"Image\" it would result in \"paragraphs--type--image\". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - paragraphs--view-mode--[view_mode]: The View Mode of the paragraph; for example, a
 *     preview would result in: \"paragraphs--view-mode--preview\", and
 *     default: \"paragraphs--view-mode--default\".
 * - view_mode: View mode; for example, \"preview\" or \"full\".
 * - logged_in: Flag for authenticated user status. Will be true when the
 *   current user is a logged-in member.
 * - is_admin: Flag for admin user status. Will be true when the current user
 *   is an administrator.
 *
 * @see template_preprocess_paragraph()
 *
 * @ingroup themeable
 */
#}
{%
  set classes = [
    'paragraph',
    'paragraph--type--' ~ paragraph.bundle|clean_class,
    view_mode ? 'paragraph--view-mode--' ~ view_mode|clean_class,
    not paragraph.isPublished() ? 'paragraph--unpublished'
  ]
%}
{% if paragraph.field_image_alt_text.value is not empty %}
  {% set alt_text =  paragraph.field_image_alt_text.value  %}
{% else %}
  {% set alt_text =  paragraph.field_image.entity.field_media_image.alt  %}
{% endif %}
{% block paragraph %}
    {% block content %}
        <div class=\"container mx-auto space-y-15 pt-25\">
            {% if paragraph.field_position.value == \"right\" %}
                <div class=\"flex flex-col lg:flex-row gap-5\">
                    <div class=\"w-full lg:w-5/12\">
                        <img src=\"{{ file_url(paragraph.field_image.entity.field_media_image.entity.uri.value) }}\" class=\"w-[fill-available] md:-mr-[100px] xl:-mr-[130px] max-h-200\" alt=\"{{ alt_text }}\">
                    </div>
                    <div class=\"w-full lg:w-7/12 space-y-2.5 lg:space-y-7.5\">
                        <h2 class=\"font-medium\">{{ paragraph.field_title.value|raw }}</h2>
                        <div class=\"text-display-xs\">
                            <h6><b>Age:</b>&nbsp;{{ paragraph.field_age.value|raw }}</h6>
                            <h6><b>Product:</b>&nbsp;{{ paragraph.field_product.value|raw }}</h6>
                            <h6><b>Years using:</b>&nbsp;{{ paragraph.field_years_using.value|raw }}</h6>
                            <h6><b>Quit date:</b>&nbsp;{{ paragraph.field_quit_date.value|raw }}</h6>
                        </div>
                        {{ paragraph.field_story.value|raw }}    
                    </div>
                </div>
            {% else %}
                <div class=\"flex flex-col lg:flex-row gap-5\">
                    <div class=\"w-full lg:w-7/12 space-y-2.5 lg:space-y-7.5\">
                        <h2 class=\"font-medium\">{{ paragraph.field_title.value|raw }}</h2>
                        <div class=\"text-display-xs\">
                            <h6><b>Age:</b>&nbsp;{{ paragraph.field_age.value|raw }}</h6>
                            <h6><b>Product:</b>&nbsp;{{ paragraph.field_product.value|raw }}</h6>
                            <h6><b>Years using:</b>&nbsp;{{ paragraph.field_years_using.value|raw }}</h6>
                            <h6><b>Quit date:</b>&nbsp;{{ paragraph.field_quit_date.value|raw }}</h6>
                        </div>
                        {{ paragraph.field_story.value|raw }}
                    </div>
                    <div class=\"w-full lg:w-5/12\">
                        <img src=\"{{ file_url(paragraph.field_image.entity.field_media_image.entity.uri.value) }}\" class=\"w-[fill-available] md:-mr-[100px] xl:-mr-[130px] max-h-200\" alt=\"{{ alt_text }}\">
                    </div>
                </div>
            {% endif %}
            
        </div>

    {% endblock %}
{% endblock paragraph %}
 
 
", "themes/custom/quitpath/templates/paragraph/paragraph--story.html.twig", "/home/quitpathshareaco/public_html/web/themes/custom/quitpath/templates/paragraph/paragraph--story.html.twig");
    }
    
    public function checkSecurity()
    {
        static $tags = ["set" => 42, "if" => 49, "block" => 54];
        static $filters = ["clean_class" => 44, "escape" => 60, "raw" => 63];
        static $functions = ["file_url" => 60];

        try {
            $this->sandbox->checkSecurity(
                ['set', 'if', 'block'],
                ['clean_class', 'escape', 'raw'],
                ['file_url'],
                $this->source
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
